% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runMCMC_btadjust.r
\name{runMCMC_btadjust}
\alias{runMCMC_btadjust}
\title{runMCMC_btadjust}
\usage{
runMCMC_btadjust(
  code = NULL,
  data = NULL,
  constants = NULL,
  model = NULL,
  MCMC_language = "Nimble",
  Nchains,
  inits = NULL,
  params = NULL,
  params.conv = NULL,
  params.save = NULL,
  niter.min = 100,
  niter.max = Inf,
  nburnin.min = 10,
  nburnin.max = Inf,
  thin.min = 1,
  thin.max = Inf,
  neff.min = NULL,
  neff.med = NULL,
  neff.mean = NULL,
  conv.max = NULL,
  conv.med = NULL,
  conv.mean = NULL,
  control = list(time.max = NULL, check.convergence = TRUE, check.convergence.firstrun =
    NULL, recheck.convergence = TRUE, convtype = "Gelman", convtype.Gelman = 2,
    convtype.Geweke = c(0.1, 0.5), convtype.alpha = 0.05, neff.method = "Stan",
    Ncycles.target = 2, props.conv = c(0.25, 0.5, 0.75), min.Nvalues = 300, min.thinmult
    = 1.1, safemultiplier.Nvals = 1.2, round.thinmult = TRUE, identifier.to.print = "",
    print.diagnostics = FALSE, print.thinmult = TRUE, innerprint = FALSE, seed = 1,
    remove.fixedchains = TRUE, 
     check.installation = TRUE),
  control.MCMC = list(confModel.expression.toadd = NULL, sampler = expression(hmc()),
    warmup = 1000, n.adapt = 1000, RNG.names = c("base::Wichmann-Hill",
    "base::Marsaglia-Multicarry", "base::Super-Duper", "base::Mersenne-Twister"), n_cores
    = NULL, showCompilerOutput = TRUE, buildDerivs = FALSE)
)
}
\arguments{
\item{code}{R object: code for the model that will be used to build the MCMC when \code{MCMC_language} is "Nimble" or "Jags". If "Nimble", must be the name (in R) of the object which is the result of the function \code{nimbleCode}. If "Jags", should be either: (i) a character string which is the name of a txt file that contains the code of the model (as used in the function jags.model): should then end up by ".txt"; or (ii) a character string that contains the text of the Jags code.}

\item{data}{R list: a list that will contain the data when \code{MCMC_language} is "Nimble" or "Jags". If "Nimble", will be sent to the \code{data} argument of the \code{nimbleModel} function in \code{nimble} package, i.e. the data that have a random distribution in the model. If \code{MCMC_language} is "Greta", can be used just to document the summary of data in the output.}

\item{constants}{R list: a list that will contain the rest of the data (in addition to data) when \code{MCMC_language} is "Nimble". Will be sent to the \code{constants} argument of the \code{nimbleModel} function in \code{nimble} package, i.e. the data that do not have a random distribution in the model. If \code{MCMC_language} is "Greta", can be used just to document the summary of other data in the output.}

\item{model}{R object: should be the result of the \code{model} command of Greta when \code{MCMC_language} is "Greta".}

\item{MCMC_language}{character value: designates the \code{MCMC_language} used to write & fit the Bayesian model in R. Current choices are "Nimble" - the default-, "Greta" or "Jags". Note that in case it is "Nimble", package \code{nimble} should be loaded in your search list.}

\item{Nchains}{integer value : the number of Markov chains to run in the MCMC.}

\item{inits}{an R list, with \code{Nchains} components. Each component is a named list that contains the initial values of the parameters for the MCMC.
In case \code{MCMC_language=="Greta"}, each component should be the result of the \code{initials} function in \code{greta} package.}

\item{params}{character vector: contains the names of the parameters to save at the end of the MCMC and to monitor for convergence and effective sample size;
inactive for convergence/effective sample size if \code{params.conv} is specified;
inactive for saving if \code{params.save} is specified.}

\item{params.conv}{character vector: contains the names of the parameters to monitor for convergence and effective sample size.}

\item{params.save}{character vector: contains the names of the parameters to be saved at the end of the MCMC.}

\item{niter.min}{integer value: the minimum number of iterations in each chain of the MCMC.}

\item{niter.max}{integer value: the maximum number of iterations in each chain of the MCMC. Will stop the MCMC once the number of iterations will reach this limit.}

\item{nburnin.min}{integer value: the minimum number of burn-in (=transitory) iterations in each chain of the MCMC.}

\item{nburnin.max}{integer value: the maximum number of burn-in (=transitory) iterations in each chain of the MCMC. Will stay at this burn-in value once this limit is reached.}

\item{thin.min}{integer value: the minimum value of the thin parameter of the MCMC.}

\item{thin.max}{integer value: the maximum value of the thin parameter of the MCMC. Will stay at this thin value once this limit is reached.}

\item{neff.min}{positive real number: minimum effective sample size - over parameters used to diagnose convergence & effective sample size- , as calculated with \code{neff.method} (specified in \code{Control}).
The algorithm will not stop if the minimum number of efficient values is not above this value (unless another limit - e.g. \code{niter.max} - is reached).}

\item{neff.med}{positive real number: median effective sample size - over parameters used to diagnose convergence & effective sample size- , as calculated with \code{neff.method} (specified in \code{Control}).
The algorithm will not stop if the median number of efficient values is not above this value (unless another limit - e.g. \code{niter.max} - is reached).}

\item{neff.mean}{positive real number: mean effective sample size - over parameters used to diagnose convergence & effective sample size-, as calculated with \code{neff.method} (specified in \code{Control}).
The algorithm will not stop if the mean number of efficient values is not above this value (unless another limit - e.g. \code{niter.max} - is reached).}

\item{conv.max}{positive real number: maximum - over parameters used to diagnose convergence & effective sample size - convergence diagnostic, as calculated with \code{convtype} method (specified in \code{Control}).
The algorithm will not stop if the maximum convergence diagnostic is not below this value (unless another limit - e.g. \code{niter.max} - is reached).}

\item{conv.med}{positive real number: median - over parameters used to diagnose convergence & effective sample size - convergence diagnostic, as calculated with \code{convtype} method(specified in \code{Control}).
The algorithm will not stop if the median convergence diagnostic is not below this value (unless another limit - e.g. \code{niter.max} - is reached).}

\item{conv.mean}{positive real number: mean - over parameters used to diagnose convergence & effective sample size - convergence diagnostic, as calculated with \code{convtype} method (specified in \code{Control}).
The algorithm will not stop if the mean convergence diagnostic is not below this value (unless another limit - e.g. \code{niter.max} - is reached).}

\item{control}{list of \code{runMCMC_btadjust} control parameters: with the following components:\cr
 \itemize{ \item \code{time.max}: positive number (units: seconds): maximum time of the process in seconds; the program will organize itself to stop before \code{0.95*time.max}. Default to NULL, corresponding to no time constraint.
  \item \code{check.convergence}: logical value: should the program check convergence at all? Default to TRUE. See Details.
  \item \code{check.convergence.firstrun}: logical value: should we check convergence after the first run? Default to NULL in which case will depend on \code{MCMC_language}: if "Greta", will be TRUE because warmup phase separated from the rest; otherwise will be FALSE.
  \item \code{recheck.convergence}: logical value: should the algorithm recheck convergence once convergence has been found in a previous run? Default to TRUE.
  \item \code{contype}: character value: specifies the type of convergence diagnostic used. Currently implemented: "Gelman" for original Gelman-Rubin diagnostic (only possible if \code{Nchains>=2}), "Gelman_new" for the version of the Gelman-Rubin diagnostic in the second version of "Bayesian Data Analysis" (Gelman, Carlin, Stern and Rubin)(only possible if \code{Nchains>=2}), "Geweke" for Geweke diagnostic (at present applied only in case \code{Nchains==1}) and "Heidleberger" for the reciprocal of Heidleberger-Welch first part of convergence diagnostic based on the Cramer-von Mises test statistic.
  \item \code{convtype.Gelman}: integer value: when \code{convtype=="Gelman"}, do we target the Point estimate diagnostic (value 1) or the Upper C.I. diagnostic (value 2). Default to 2.
  \item \code{convtype.Geweke}: real vector with two components between 0 and 1: (i) the fraction of samples to consider as the beginning of the chain (frac1 in geweke.diag); (ii) the fraction of samples to consider as the end of the chain (frac2 in \code{gewke.diag}). Default to c(0.1,0.5) as in \code{geweke.diag}.
  \item \code{convtype.alpha}: real value between 0 and 1: significance level used in case \code{convtype=="Gelman"} and \code{convtype.Gelman==2}, or \code{convtype=="Heidleberger"}
  \item \code{neff.method}: character value: method used to calculate the effective sample sizes. Current choice between "Stan" (the default) and "Coda". If "Stan", uses the function \code{monitor} in package \code{rstan}. If "Coda", uses the function \code{effectiveSize} in package \code{coda}.
  \item \code{Ncycles.target}: integer value: targeted number of MCMC runs. Default to 2.
  \item \code{props.conv}: numeric vector: in case of non convergence: quantiles of number of iterations removed to recheck convergence. Values should be between 0 and 1.
  \item \code{min.Nvalues}: integer value: minimum number of values to diagnose convergence of level of autocorrelation.
  \item \code{round.thinmult}: logical value: should the thin multiplier be rounded to the nearest integer so that past values are precisely positioned on the modified iteration sequence? Default to TRUE. Value of FALSE may not be rigorous or may not converge well.
  \item \code{min.thinmult}: numeric value: minimum value of thin multiplier: if diagnostics suggest to multiply by less than this, this is not done and the current situation of autocorrelation is considered OK.
  \item \code{seed}: integer number: seed for the pseudo-random number generator inside runMCMC_btadjust.
  \item \code{identifier.to.print}: character string: printed each time an MCMC update is ran to identify the model (esp. if multiple successive calls to \code{runMCMC_btadjust} are made).
  \item \code{safemultiplier.Nvals}: positive number: number bigger than 1 used to multiply the targeted number of efficient values in calculations of additional number of iterations.
  \item \code{print.diagnostics}: logical value: should diagnostics be printed each time they are calculated? Default to FALSE.
  \item \code{print.thinmult}: logical value: should the raw multiplier of thin be printed each time it is calculated? Default to TRUE.
  \item \code{innerprint}: logical value: should printings be done inside the function \code{monitor} of \code{rstan} in case \code{neff.method=="Stan"}? Default to FALSE.
  \item \code{remove.fixedchains}: logical value: should we remove Markov chains that do not vary (i.e. whose all parameters have zero variances)? Default to TRUE.
  \item \code{check.installation}: logical value: should the function check installation of packages and programs? Default to TRUE.
}}

\item{control.MCMC}{list of MCMC control parameters: with the following components - that depend on \code{MCMC_language}:
 \itemize{ \item \code{confModel.expression.toadd} (only for \code{MCMC_language=="Nimble"}): expression to add to \code{confModel} to specify samplers, remove nodes... \code{confModel} should be referred to by \code{confModel[[i]]}. See Details for an example.
\item \code{sampler} (only for \code{MCMC_language=="Greta"}): expression used to specify the sampler used.
\item \code{warmup} (only for \code{MCMC_language=="Greta"}): integer value used as warmup parameter in the mcmc.
\item \code{n.adapt} (only for \code{MCMC_language=="Jags"}): integer value: number of iterations used for adaptation (in function \code{jags.model} in \code{rjags} package).
\item \code{RNG.names} (only for \code{MCMC_language=="Jags"}): character vector: name of pseudo-random number generators for each chain. Each component of the vector should be among "base::Wichmann-Hill", "base::Marsaglia-Multicarry", "base::Super-Duper", "base::Mersenne-Twister". If less values than \code{Nchains} are provided, they are specified periodically.
\item \code{n_cores} (only for \code{MCMC_language=="Greta"}): integer or NULL: maximum number of cores to use by each sampler.
\item \code{showCompilerOutput} (only for \code{MCMC_language=="Nimble"}): logical value indicating whether details of C++ compilation should be printed. Default to TRUE.
\item \code{buildDerivs} (only for \code{MCMC_language=="Nimble"}): logical value indicating derivatives should be prepared when preparing Nimble model (will esp. allow to use HMC sampler). Default to FALSE.
}}
}
\value{
a \code{mcmc.list} object with attributes with the following components:
      \itemize{ \item \code{call.params}: a list containing most of the important arguments of the \code{runMCMC_btadjust} call as well as a summary of dimensions/lengths and mean of components of \code{data} and \code{constants} arguments.
      \item \code{final.params}: a list with the parameters of the MCMC at the end of fitting:
            \itemize{ \item \code{burnin}: number of iterations of the transient (burn-in) period
            \item \code{thin}: number of iterations used for thinning the final output
            \item \code{niter.tot}: total number of iterations (of each MCMC chain)
            \item \code{duration}: total duration (elapsed time) of the fit (in seconds)
            \item \code{duration.MCMC.preparation}: duration (elapsed time) of MCMC preparation (in seconds)
            \item \code{duration.MCMC.transient}: duration (elapsed time) of the MCMC transient (burn-in) phase (in seconds)
            \item \code{duration.MCMC.asymptotic}: duration (elapsed time) of the MCMC asymptotic phase (in seconds)
            \item \code{duration.btadjust}: duration (elapsed time) outside MCMC preparation & fitting (in seconds)
            \item \code{CPUduration}: total CPU duration (user+system) of the fit (in seconds)
            \item \code{CPUduration.MCMC.preparation}: CPU duration (user+system) of MCMC preparation (in seconds)
            \item \code{CPUduration.MCMC.transient}: CPU duration (user+system) of the MCMC transient (burn-in) phase (in seconds)
            \item \code{CPUduration.MCMC.asymptotic}: CPU duration (user+system) of the MCMC asymptotic phase (in seconds)
            \item \code{CPUduration.btadjust}: CPU duration (user+system) outside MCMC preparation & fitting (in seconds)
            \item \code{time}: time (from Sys.time) at the end of model fitting
            }
       \item \code{final.diags}: a list with final diagnostics of the fit:
            \itemize{ \item \code{params}: parameters of the MCMC (burn-in, thin, niter...)
            \item \code{conv_synth}: synthetic output of convergence diagnostics
            \item \code{neff_synth}: synthetic output for calculations of effective sample sizes
            \item \code{conv}: raw convergence values for all the parameters being diagnosed
            \item \code{neff}: raw effective sample size values for all the parameters being diagnosed
            }
       \item \code{package.versions}: a named vector with the versions of the packages used during MCMC fitting
       \item \code{R.version}: a list giving the different details of the R setup during MCMC fitting
       \item \code{warnings}: a list of the warning messages issued during fitting; unsure it still works with this version
       \item \code{error}: a list with the error messages issued during fitting; unsure it still works with this version
       }
}
\description{
returns a mcmc.list object which is the output of a Markov Chain Monte Carlo obtained after adjusting burn-in & thinning parameters to meet pre-specified criteria in terms of convergence & effective sample size - i.e. sample size adjusted for autocorrelation - of the MCMC output
}
\details{
Recap: \cr
If \code{MCMC_language=="Nimble"}, the code, data and constants arguments should be specified according to the requirements of \code{nimble} package. \cr
If \code{MCMC_language=="Jags"}, the code and  data arguments need to be specified as required by \code{rjags} package.  \cr
If \code{MCMC_language=="Greta"}, the model argument must be specified and should be the result of the \code{model} command in \code{greta} package.  \cr

Details on \code{check.convergence}: \cr
If FALSE, no check of convergence at all, after \code{nburnin.min} (& \code{recheck.convergence} is put to FALSE & \code{check.convergence.firstrun} is dominated by \code{check.convergence}). \cr
If TRUE, the convergence behavior is governed by \code{check.convergence.firstrun} & \code{recheck.convergence}.\cr

Example for \code{confModel.expression.toadd} component of \code{control.MCMC}:\cr
		\code{confModel.expression.toadd<-expression({ConfModel[[i]]$removeSamplers(c("alpha","dzetad","beta","exper_bias[2]","exper_bias[3]","exper_precision[2]","exper_precision[3]"))
			ConfModel[[i]]$addSampler(target = c("alpha","dzetad","beta"),type = "RW_block")
			ConfModel[[i]]$addSampler(target = c("exper_bias[2]","exper_bias[3]"),type = "RW_block")
			ConfModel[[i]]$addSampler(target = c("exper_precision[2]","exper_precision[3]"),type = "RW_block")
			})}

Remark for \code{params, params.conv, params.save}:\cr
in cases of parameters that are vectors, matrices... the \code{params} vector can contain only the name of the vector or matrix... in which case all its components will be used. It can also contain the names of individual components.
}
\examples{
 #\code{
# for examples with Nimble or Greta, see the Vignette.
# condition variable of whether installation is OK with Jags to avoid error durong package check
condition_jags<-TRUE
if (nchar(system.file(package='rjags'))==0) {condition_jags<-FALSE}
if (nchar(system.file(package='runjags'))==0) {condition_jags<-FALSE}
if (condition_jags)
{suppressWarnings(temp<-runjags::testjags(silent=TRUE))
 if(!(temp$JAGS.available&temp$JAGS.found&temp$JAGS.major==4)) {condition_jags<-FALSE}}

if (condition_jags) {
#generating data
set.seed(1)
y1000<-rnorm(n=1000,mean=600,sd=30)
ModelData <-list(mass = y1000,nobs = length(y1000))

#writing the Jags code as a character chain in R
modeltotransfer<-"model {

# Priors
population.mean ~ dunif(0,5000)
population.sd ~ dunif(0,100)

# Precision = 1/variance: Normal distribution parameterized by precision in Jags
population.variance <- population.sd * population.sd
precision <- 1 / population.variance

# Likelihood
for(i in 1:nobs){
  mass[i] ~ dnorm(population.mean, precision)
 }
 }"

#specifying the initial values
ModelInits <- function()
{list (population.mean = rnorm(1,600,90), population.sd = runif(1, 1, 30))}
params <- c("population.mean", "population.sd", "population.variance")
K<-3
set.seed(1)
Inits<-lapply(1:K,function(x){ModelInits()})

# running runMCMC_btadjust with MCMC_language="Jags":
set.seed(1)
out.mcmc.Coda<-runMCMC_btadjust(MCMC_language="Jags", code=modeltotransfer,
data=ModelData,
Nchains=K, params=params, inits=Inits,
niter.min=1000, niter.max=300000,
nburnin.min=100, nburnin.max=200000,
thin.min=1, thin.max=1000,
neff.min=1000, conv.max=1.05,
control=list(print.diagnostics=TRUE, neff.method="Coda"))

summary(out.mcmc.Coda)
}
#}
}
