% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ruminate.R
\docType{package}
\name{ruminate}
\alias{ruminate-package}
\alias{ruminate}
\title{ruminate: Shiny app and module to facilitate pharamacometrics analysis}
\usage{
ruminate(
  host = "127.0.0.1",
  port = 3838,
  server_opts = list(shiny.maxRequestSize = 30 * 1024^2),
  mksession = FALSE
)
}
\arguments{
\item{host}{Hostname of the server ("127.0.0.1")}

\item{port}{Port number for the app (3838)}

\item{server_opts}{List of options (names) and their vlues (value) e.g.
\code{list(shiny.maxRequestSize = 30 * 1024^2)}.}

\item{mksession}{Boolean value, when TRUE will load test session data
for app testing}
}
\value{
Nothing is returned, this function just runs the built-in ruminate
app.
}
\description{
This is done by creating a Shiny interface to different tools for data
transformation (\code{dplyr} and \code{tidyr}), plotting (\code{ggplot2}), and
noncompartmental analysis (\code{PKNCA}). These results can be reported in Excel,
Word or PowerPoint. The state of the app can be saved and loaded at a later
date. When saved, a script is generated to reproduce the different actions in
the Shiny interface.

Runs the pharmacometrics ruminate app.
}
\examples{
if (interactive()) {
ruminate()
}
}
\seealso{
\url{https://ruminate.ubiquity.tools/}
}
\author{
\strong{Maintainer}: John Harrold \email{john.m.harrold@gmail.com} (\href{https://orcid.org/0000-0003-2052-4373}{ORCID})

}
