% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/direct_messages.R
\name{direct_messages}
\alias{direct_messages}
\alias{direct_messages_sent}
\title{Get direct messages sent to and received by the authenticating user from the
past 30 days}
\usage{
direct_messages(n = 50, next_cursor = NULL, parse = TRUE,
  token = NULL)

direct_messages_sent(since_id = NULL, max_id = NULL, n = 200,
  parse = TRUE, token = NULL)
}
\arguments{
\item{n}{optional Specifies the number of direct messages to try
and retrieve, up to a maximum of 50.}

\item{next_cursor}{If there are more than 200 DMs in the last 30 days,
responses will include a next_cursor value, which can be supplied in
additional requests to scroll through pages of results.}

\item{parse}{Logical indicating whether to convert response object
into nested list. Defaults to true.}

\item{token}{Every user should have their own Oauth (Twitter API) token. By
default \code{token = NULL} this function looks for the path to a saved
Twitter token via environment variables (which is what `create_token()`
sets up by default during initial token creation). For instruction on how
to create a Twitter token see the tokens vignette, i.e.,
`vignettes("auth", "rtweet")` or see \code{?tokens}.}

\item{since_id}{optional Returns results with an ID greater than
(that is, more recent than) the specified ID. There are limits to
the number of Tweets which can be accessed through the API. If
the limit of Tweets has occurred since the since_id, the since_id
will be forced to the oldest ID available.}

\item{max_id}{Character, returns results with an ID less than (that is,
older than) or equal to `max_id`.}
}
\value{
Return parsed or non-parsed response object.
}
\description{
Returns all Direct Message events (both sent and received) within the last 30
days. Sorted in reverse-chronological order.
}
\details{
Includes detailed information about the sender and
  recipient user. You can request up to 50 direct messages per
  call, and only direct messages from the last 30 days will be
  available using this endpoint.

  Important: This method requires an access token with read,
  write, and direct message permissions. To change your application's
  permissions, navigate to \url{apps.twitter.com}, select the
  appropriate application, click the "permissions" tab. Once you' have made
  changes to the application permission settings, you will need to
  regenerate your token before those effect of those changes can
  take effect.
}
\examples{

\dontrun{

## get my direct messages
dms <- direct_messages()

## inspect data structure
str(dms)

}

}
