% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lists_subscribers.R
\name{lists_subscribers}
\alias{lists_subscribers}
\title{Get subscribers of a specified list.}
\usage{
lists_subscribers(list_id = NULL, slug = NULL, owner_user = NULL,
  n = 20, cursor = "-1", parse = TRUE, token = NULL)
}
\arguments{
\item{list_id}{required The numerical id of the list.}

\item{slug}{required You can identify a list by its slug instead of
its numerical id. If you decide to do so, note that you'll also
have to specify the list owner using the owner_id or
owner_user parameters.}

\item{owner_user}{optional The screen name or user ID of the user
who owns the list being requested by a slug.}

\item{n}{optional Specifies the number of results to return
per page (see cursor below). The default is 20, with a maximum
of 5,000.}

\item{cursor}{semi-optional Causes the collection of list members
to be broken into "pages" of consistent sizes (specified by
the count parameter). If no cursor is provided, a
value of -1 will be assumed, which is the first "page."
The response from the API will include a previous_cursor
and next_cursor to allow paging back and forth. See Using
cursors to navigate collections for more information.}

\item{parse}{Logical indicating whether to convert the response object into
an R list. Defaults to TRUE.}

\item{token}{OAuth token. By default \code{token = NULL} fetches a
non-exhausted token from an environment variable. Find
instructions on how to create tokens and setup an environment
variable in the tokens vignette (in r, send \code{?tokens} to
console).}
}
\description{
Get subscribers of a specified list.
}
\examples{

\dontrun{

## get subscribers of new york times politics list
rstats <- lists_subscribers(
  slug = "new-york-times-politics",
  owner_user = "nytpolitics",
  n = 1000
)

}

}
\seealso{
Other lists: \code{\link{lists_members}},
  \code{\link{lists_statuses}}, \code{\link{lists_users}}

Other users: \code{\link{as_screenname}},
  \code{\link{lookup_users}}, \code{\link{search_users}},
  \code{\link{tweets_with_users}}, \code{\link{users_data}}
}
