% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lists_members.R, R/lists_memberships.R
\name{lists_members}
\alias{lists_members}
\alias{lists_memberships}
\title{Get the members of a specified Twitter list.}
\usage{
lists_members(list_id = NULL, slug = NULL, owner_user = NULL, n = 5000,
  cursor = "-1", token = NULL, parse = TRUE, ...)

lists_memberships(user, n = 20, cursor = "-1",
  filter_to_owned_lists = FALSE, token = NULL, parse = TRUE)
}
\arguments{
\item{list_id}{required The numerical id of the list.}

\item{slug}{required You can identify a list by its slug instead of
its numerical id. If you decide to do so, note that you'll also
have to specify the list owner using the owner_id or
owner_user parameters.}

\item{owner_user}{optional The screen name or user ID of the user
who owns the list being requested by a slug.}

\item{n}{Specifies the number of results to return
per page (see cursor below). The default is 20, with a maximum
of 5,000.}

\item{cursor}{optional Breaks the results into pages. Provide a
value of -1 to begin paging. Provide values as returned in the
response body's next_cursor and previous_cursor attributes to
page back and forth in the list.}

\item{token}{OAuth token. By default \code{token = NULL} fetches a
non-exhausted token from an environment variable. Find
instructions on how to create tokens and setup an environment
variable in the tokens vignette (in r, send \code{?tokens} to
console).}

\item{parse}{Logical indicating whether to convert the response object into
an R list. Defaults to TRUE.}

\item{...}{Other arguments used as parameters in query composition.}

\item{user}{The user id or screen_name of the user for whom to
return results for.}

\item{filter_to_owned_lists}{When set to true . t or 1 , will
return just lists the authenticating user owns, and the user
represented by user_id or screen_name is a member of.}
}
\value{
Either a nested list (if parsed) or an HTTP response object.
}
\description{
Get the members of a specified Twitter list.

Get the lists a specified user has been added to.
}
\details{
Due to deleted or removed lists, the returned number of memberships
  is often less than the provided n value. This is a reflection of the API and
  not a unique quirk of rtweet.
}
\examples{
\dontrun{

## get list memebers for a list of polling experts using list_id
(pollsters <- lists_members("105140588"))

## get list members of cspan's senators list
sens <- lists_members(slug = "senators", owner_user = "cspan")
sens

## get list members for an rstats list using list topic slug
## list owner's screen name
rstats <- lists_members(slug = "rstats", owner_user = "scultrera")
rstats

}

\dontrun{

## get up to 200 list memberships of Nate Silver
ns538 <- lists_memberships("NateSilver538", n = 200)

## view data
ns538

}

}
\seealso{
Other lists: \code{\link{lists_statuses}},
  \code{\link{lists_subscribers}},
  \code{\link{lists_users}}
}
