% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/friends.R
\name{ply_friends}
\alias{ply_friends}
\title{ply_friends}
\usage{
ply_friends(users, token = NULL, ...)
}
\arguments{
\item{users}{Screen names and/or user ids of target user. Since
friend networks are requested one at a time, users can be a mixture of
user_ids and screen_names.}

\item{token}{OAuth token. By default \code{token = NULL} fetches a
non-exhausted token from an environment variable. Find instructions
on how to create tokens and setup an environment variable in the
tokens vignette (in r, send \code{?tokens} to console).}

\item{\dots}{Arguments passed on to \code{\link{get_friends}}.}
}
\value{
List of friend networks where \code{n}th element contains
  user ids of \code{n}th users.
}
\description{
ply_friends
}
\examples{
\dontrun{
get friend networks for up to 15 users per token
users <- c("inside_R", "rtweet_package", "RLangTip", "Rbloggers", "rstudio")
friend.networks <- ply_friends(users)
friend.networks[[1]]
str(friend.networks)
}
}

