% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_add_positions_to_frames.R
\name{ts_add_positions_to_frames}
\alias{ts_add_positions_to_frames}
\title{Add points, coordinates, or polygons to a list of spatial plots}
\usage{
ts_add_positions_to_frames(
  r_frame_list,
  positions,
  position_names = NULL,
  pcol = "red",
  tcol = "red",
  psize = 2,
  tsize = 7,
  ttype = "text",
  t_hjust = 0,
  t_vjust = 0,
  position_legend_title = "Position",
  legend_position = "right",
  aes_by_pos = FALSE,
  col_by_pos = FALSE,
  add_text = FALSE
)
}
\arguments{
\item{r_frame_list}{list of ggplots, as generated by \code{\link{ts_makeframes}}.}

\item{positions}{object containing the coordinates. One of \itemize{
 \item{A two-column \code{matrix} of coordinates where the first column corresponds to the longitude and the second column corresponds to the latitude.}
 \item{A \code{SpatialPolygonsDataFrame} from which \link[sp]{coordinates} can be extracted.}
 \item{A \code{SpatialPointsDataFrame} from which \link[sp]{coordinates} can be extracted.}
 \item{An sf object containing \code{POINTS},\code{POLYGONS} or \code{MULTIPOLYGONS}}
}}

\item{position_names}{(Optional) character, names of the positions to be added in legend or text (If \code{add_text}). By default, will create placeholder names by combining the object type and Id (Example: *"Polygon 3"*)}

\item{pcol}{(Optional) character, color of the spatial objects. Default is \code{"red"}.}

\item{tcol}{(Optional) character, if \code{add_text}: The color of the text. Default is \code{"red"}.}

\item{psize}{(Optional) numeric, plot size of the spatial objects. Default is \code{2}.}

\item{tsize}{(Optional) numeric, if \code{add_text}: The size of the text. Default is \code{7}.}

\item{ttype}{(Optional) character, if \code{add_text}: The type of the text. Either \code{"label"} or \code{"text"}. Default is \code{"text"}.}

\item{t_hjust}{(Optional) numeric, if \code{add_text}: Horizontal offset of the text in map units. Default is \code{0}.}

\item{t_vjust}{(Optional) numeric, if \code{add_text}: Vertical offset of the text in map units. Default is \code{0}.}

\item{position_legend_title}{(Optional) character, title of the legend. Default is \code{"Position"}.}

\item{legend_position}{(Optional) character, position of the legend. Use \code{"none"} to disable the legend. Default is \code{"right"}}

\item{aes_by_pos}{(Optional) logical. If \code{TRUE}: vary some aesthetic (linetype for polygons, shape for points) to be different for each position? If  \code{FALSE}, this also disables the legend, as no notable classes will be plotted. Default is \code{FALSE}.}

\item{col_by_pos}{(Optional) logical. If \code{TRUE}: vary the color to be different for each position? If  \code{TRUE}, overrides \code{aes_by_pos} and {pcol}. Default is \code{FALSE}.}

\item{add_text}{(Optional) logical.  If \code{TRUE}: add a text to each position using \link[moveVis]{add_text}.  Default is \code{"False"}.}
}
\value{
A list of ggplots with added positions.
}
\description{
Add points, coordinates, or polygons to a list of spatial plots
}
\details{
The function takes a \code{positions} object, which can be a spatial object or a matrix of coordinates, and adds them to each of the elements of \code{r_frame_list}. Optionally it also adds text at their respective positions using\link[moveVis]{add_text}.

- \code{ts_add_positions_to_frames} is intended to be an easy way to add multiple objects to the spatial frames at fixed positions. 
For adding individual positions or text, potentially at varying positions, it is recommended to all \link[moveVis]{add_gg} and \link[moveVis]{add_text} directly.
}
\examples{
#Setup
 library(rtsVis)
 library(ggplot2)
 # Load example dataset at a greatly increased interval
x_list <- MODIS_SI_ds[seq(1,length(MODIS_SI_ds),30)]
x_dates <- do.call(c, lapply(MODIS_SI_ds,attr,"time") )[seq(1,length(MODIS_SI_ds),30)]

#Fill NAs
x_list_filled <- ts_fill_na(x_list)

#Make a sequence of output dates, double the length of input dates
out_dates <-seq.POSIXt(from = x_dates[1],
                       to = x_dates[length(x_dates)],length.out = length(x_dates)*2 )

#For each output date, interpolate a raster image from the input files
r_list_out <- ts_raster(r_list = x_list_filled,
                        r_times = x_dates,
                        out_times = out_dates,
                        fade_raster = TRUE)
#Create the frames 
# as from the desired layers
r_frames <- ts_makeframes(x_list = r_list_out,samplesize = 10,
                          l_indices = c(1,4,3))

#optional: Use moveVis functions to add additional elements to our frames
#library(magrittr)
# r_frames <- r_frames \%>\%
#   moveVis::add_labels(x = "Longitude", y = "Latitude")\%>\% 
#   moveVis::add_northarrow(colour = "white", position = "bottomright") \%>\% 
#   moveVis::add_timestamps(type = "label") \%>\% 
#   moveVis::add_progress()


#### Add the polygons
# Add polygons to the frames
polygons <- SI_positions$polygons #Polygons of Slovenian municipalities covered by the raster
r_frames_style_poly <-
  ts_add_positions_to_frames(
    r_frame_list = r_frames,
    positions = polygons,
    psize = 1,
    pcol = "red",
    position_names = c("Radece", "Ljubljana", "Kocevje"),
    position_legend_title = "Obcina",
    legend_position = "left",
    aes_by_pos = FALSE
  )
#Look at one of the new frames
r_frames_style_poly[5]

#Alternatively add points
points <- SI_positions$points #Points in Slovenia
r_frames_style_point <- rtsVis::ts_add_positions_to_frames(r_frame_list = r_frames,
                                                           positions = points,
                                                           psize = 4,
                                                           pcol = "orange",
                                                           position_names = c("Ljubljana",
                                                                              "Ivancna Gorica",
                                                                              "Dolenjske Toplice",
                                                                              "Loski Potok"),
                                                           position_legend_title = "Obcina",
                                                           legend_position = "right",
                                                           aes_by_pos = TRUE,
                                                           add_text = TRUE,
                                                           ttype = "label",
                                                           tsize = 3,
                                                           t_hjust = -3000,
                                                           t_vjust = 1000)
#Look at one of the new frames
# r_frames_style_point[5]


#Alternatively add points
# points_mat <- SI_positions$points_matrix #Points in Slovenia
# r_frames_style_point_mat <- ts_add_positions_to_frames(r_frame_list = r_frames,
#                                                       positions = points_mat,
#                                                       psize = 4,
#                                                       pcol = "orange",
#                                                       position_names = c("A",
#                                                                          "B" ),
#                                                      position_legend_title = "Point",
#                                                       legend_position = "right",
#                                                       aes_by_pos = TRUE,
#                                                       add_text = TRUE,
#                                                       ttype = "label",
#                                                       tsize = 3,
#                                                       t_hjust = -3000,
#                                                       t_vjust = 1000)
#Look at one of the new frames
# r_frames_style_point_mat[5]
}
\seealso{
\link[moveVis]{add_text} \link[moveVis]{add_gg}
}
\author{
Johannes Mast
}
