% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_tdf.R
\name{read_tdf}
\alias{read_tdf}
\alias{read_tdf.character}
\alias{read_tdf.trimcommand}
\title{Read TRIM data files}
\usage{
read_tdf(x, ...)

\method{read_tdf}{character}(x, missing = -1, weight = FALSE, ncovars = 0,
  labels = character(0), ...)

\method{read_tdf}{trimcommand}(x, ...)
}
\arguments{
\item{x}{a filename or a \code{\link{trimcommand}} object}

\item{...}{(unused)}

\item{missing}{\code{[integer]} missing value indicator.
Missing values are translated to \code{\link[base]{NA}}.}

\item{weight}{\code{[logical]} indicate presence of a weight column}

\item{ncovars}{\code{[logical]} The number of covariates in the file}

\item{labels}{\code{[character]} (optional) specify labels for the covariates.
Defaults to \code{cov<i>} (\code{i=1,2,...,ncovars}) if none are specified.}
}
\value{
A \code{data.frame}.
}
\description{
Read data files intended for the original TRIM programme.
}
\section{The TRIM data file format}{


TRIM input data is stored in a \code{ASCII} encoded file where headerless columns
are separated by one or more spaces. Below are the columns as \code{read_tdf} expects
them.

\tabular{lll}{
\bold{Variable}    \tab\bold{status}   \tab \bold{R type}\cr
\code{site}        \tab requiered \tab \code{integer}\cr
\code{time}        \tab required  \tab \code{integer}\cr
\code{count}       \tab required  \tab \code{numeric}\cr
\code{weight}      \tab optional  \tab \code{numeric}\cr
\code{<covariate1>}\tab optional\tab \code{integer}\cr
\code{...}\tab\tab\cr
\code{<covariateN>}\tab optional\tab \code{integer}\cr
}
}

\seealso{
Other modelspec: \code{\link{check_observations}},
  \code{\link{read_tcf}}, \code{\link{set_trim_verbose}},
  \code{\link{trimcommand}}, \code{\link{trim}}
}
