% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mkTrend_r.R, R/mkTrend_rcpp.R
\name{mkTrend_r}
\alias{mkTrend_r}
\alias{mkTrend}
\title{Modified Mann Kendall}
\usage{
mkTrend_r(y, ci = 0.95, IsPlot = FALSE)

mkTrend(y, x = seq_along(y), ci = 0.95, IsPlot = FALSE)
}
\arguments{
\item{y}{numeric vector}

\item{ci}{critical value of autocorrelation}

\item{IsPlot}{boolean}

\item{x}{(optional) numeric vector}
}
\value{
\itemize{
\item \code{Z0}   : The original (non corrected) Mann-Kendall test Z statistic.
\item \code{pval0}: The original (non corrected) Mann-Kendall test p-value
\item \code{Z}    : The new Z statistic after applying the correction
\item \code{pval} : Corrected p-value after accounting for serial autocorrelation
\code{N/n*s} Value of the correction factor, representing the quotient of the number
of samples N divided by the effective sample size \code{n*s}
\item \code{slp}  : Sen slope, The slope of the (linear) trend according to Sen test
}
}
\description{
If valid observations <= 5, NA will be returned.
}
\details{
mkTrend is 4-fold faster with \code{.lm.fit}.
}
\note{
slp is significant, if pval < alpha.
}
\examples{
x <- c(4.81, 4.17, 4.41, 3.59, 5.87, 3.83, 6.03, 4.89, 4.32, 4.69)
r <- mkTrend(x)
r_cpp <- mkTrend(x, IsPlot = TRUE)
}
\references{
Hipel, K.W. and McLeod, A.I. (1994),
\emph{Time Series Modelling of Water Resources and Environmental Systems}.
New York: Elsevier Science.

Libiseller, C. and Grimvall, A., (2002), Performance of partial
Mann-Kendall tests for trend detection in the presence of covariates.
\emph{Environmetrics} 13, 71--84, \doi{10.1002/env.507}.
}
\seealso{
\code{fume::mktrend} and \code{trend::mk.test}
}
\author{
Dongdong Kong
}
