% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cg_memberbystatedistrict.R
\name{cg_memberbystatedistrict}
\alias{cg_memberbystatedistrict}
\title{Get a list of the most recent new members of the current Congress.}
\usage{
cg_memberbystatedistrict(chamber = NULL, state = NULL, district = NULL,
  key = NULL, ...)
}
\arguments{
\item{chamber}{One of 'house' or 'senate'.}

\item{state}{Limits the list of members by state; two-letter state code (e.g., CA).}

\item{district}{Limits the list of members by district (House only). If you specify
a district, you must also specify a state. If the district number you
specify is higher than the total number of districts for that state,
a 404 response will be returned.}

\item{key}{(character) your Propublica API key; pass in, or loads from 
.Renviron as \code{PROPUBLICA_API_KEY}. See \code{\link{rtimes-package}} 
for info on rate limits.}

\item{...}{Curl options (debugging tools mostly) passed to 
\code{\link[crul]{HttpClient}}}
}
\value{
List of new members of he current Congress.
}
\description{
Get a list of the most recent new members of the current Congress.
}
\examples{
\dontrun{
cg_memberbystatedistrict(chamber='senate', state='NH')
cg_memberbystatedistrict(chamber='senate', state='CA')
cg_memberbystatedistrict(chamber='senate', state='OR')
cg_memberbystatedistrict(chamber='house', state='OR', district=1)
}
}
\references{
Congress API docs
\url{https://projects.propublica.org/api-docs/congress-api/}
}
\seealso{
Other congress: \code{\link{cg_billscosponsor}},
  \code{\link{cg_memberappear}},
  \code{\link{cg_memberbioroles}},
  \code{\link{cg_membersleaving}},
  \code{\link{cg_memberslist}},
  \code{\link{cg_membersponsorcompare}},
  \code{\link{cg_membervotecompare}},
  \code{\link{cg_membervotepositions}},
  \code{\link{cg_newmembers}},
  \code{\link{cg_rollcallvote}}
}
