% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf_candidate_leaders.R
\name{cf_candidate_leaders}
\alias{cf_candidate_leaders}
\title{Campaign finance - candidate leaders}
\usage{
cf_candidate_leaders(campaign_cycle = NULL, category = NULL, key = NULL,
  ...)
}
\arguments{
\item{campaign_cycle}{An even-numbdered year in YYYY format. Presidential data:
2008-present; Congressional data: 2000-present}

\item{category}{Category. Specify one of these categories:
\itemize{
 \item Candidate Loan `candidate-loan`
 \item Contribution Total `contribution-total`
 \item Debts Owed `debts-owed`
 \item Disbursements Total `disbursements-total`
 \item End Cash `end-cash`
 \item Individual Total `individual-total`
 \item PAC Total `pac-total`
 \item Receipts Total `receipts-total`
 \item Refund Total `refund-total`
}}

\item{key}{(character) your Propublica API key; pass in, or loads from .Renviron as 
\code{PROPUBLICA_API_KEY}. See \code{\link{rtimes-package}} for info on rate limits.}

\item{...}{Curl options (debugging tools mostly) passed to \code{\link[httr]{GET}}}
}
\description{
Campaign finance - candidate leaders
}
\examples{
\dontrun{
cf_candidate_leaders(campaign_cycle = 2010, category='end-cash')
cf_candidate_leaders(campaign_cycle = 2008, category='receipts-total')
}
}
\references{
\url{http://propublica.github.io/campaign-finance-api-docs}
}
