% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oup_article.R
\name{oup_article}
\alias{oup_article}
\title{Oxford University Press.}
\usage{
oup_article(
  oup_version = 0,
  journal = NULL,
  number_sections = FALSE,
  citation_package = ifelse(oup_version == 0, "default", "natbib"),
  papersize = c("large", "medium", "small"),
  document_style = c("contemporary", "modern", "traditional"),
  namedate = FALSE,
  onecolumn = FALSE,
  number_lines = FALSE,
  number_lines_options = NULL,
  keep_tex = TRUE,
  md_extensions = c("-autolink_bare_uris"),
  pandoc_args = NULL,
  ...
)
}
\arguments{
\item{oup_version}{set to 0 (default) to use the 2009 OUP \code{ouparticle.cls}
included or set to 1 to use the newer 2020 OUP package
\code{oup-authoring-template} available on CTAN.}

\item{journal}{journal Title. \emph{(Only useful for \code{oup_version > 0})}.}

\item{number_sections}{It will be passed to \code{\link[rmarkdown:pdf_document]{rmarkdown::pdf_document()}}. Set to
TRUE by default when \code{oup_version = 1} is used.}

\item{citation_package}{The LaTeX package to process citations, \code{natbib}
or \code{biblatex}. Use \code{default} if neither package is to be used,
which means citations will be processed via the command
\command{pandoc-citeproc}.}

\item{papersize}{one of "large" (default), "medium", or "small" setting
output page size. \emph{(Only useful for \code{oup_version > 0})}}

\item{document_style}{one of "contemporary" (default), "modern", or
"traditional" setting overall style of document. \emph{(Only useful for \code{oup_version > 0})}}

\item{namedate}{a logical variable
indicating if natbib citations should be in name-date format. Defaults to
\code{FALSE}. \emph{(Only useful for \code{oup_version > 0})}}

\item{onecolumn}{a logical variable indicating if one column formatting
should be used. Defaults to \code{FALSE}. \emph{(Only useful for \code{oup_version > 0})}}

\item{number_lines, number_lines_options}{Control the usage of CTAN package
\code{lineno} in the template. Use \code{number_lines =TRUE} to activate and set
\code{number_lines_options} to change options. \emph{(Only useful for \code{oup_version > 0})}}

\item{keep_tex}{Keep the intermediate tex file used in the conversion to PDF.
Note that this argument does not control whether to keep the auxiliary
files (e.g., \file{.aux}) generated by LaTeX when compiling \file{.tex} to
\file{.pdf}. To keep these files, you may set \code{options(tinytex.clean =
FALSE)}.}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition of R Markdown. See the \code{\link[rmarkdown]{rmarkdown_format}} for
additional details.}

\item{pandoc_args}{Additional command line options to pass to pandoc}

\item{...}{Additional arguments to \code{\link[rmarkdown:pdf_document]{rmarkdown::pdf_document()}}}
}
\description{
Format for creating submissions to many Oxford University Press journals.
Adapted from
\url{https://academic.oup.com/pages/authoring/journals/preparing_your_manuscript}
and \url{https://academic.oup.com/icesjms/pages/General_Instructions}. and the
\code{oup-authoring-template} available on CTAN at
\url{https://www.ctan.org/pkg/oup-authoring-template}.
}
\details{
Note that for
\itemize{
\item \code{oup_version=0}, \code{citation_package="default"} by default,
\item \code{oup_version=1}, \code{citation_package="natbib"} by default and
\code{citation_package="biblatex"} is not supported.
}
}
\section{Pandoc requirement}{
\code{oup_version = 1} requires a minimum version of 2.10.
}

\examples{
\dontrun{
# Use old template based on `ouparticle.cls`
rmarkdown::draft("MyArticle.Rmd", template = "oup_v0", package = "rticles")
# Use new template based on `oup-authoring-template` CTAN package
rmarkdown::draft("MyArticle.Rmd", template = "oup_v1", package = "rticles")
}
}
