% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfbs.R
\name{gcContent.ms}
\alias{gcContent.ms}
\title{Get GC content of each sequence in an MS object}
\usage{
gcContent.ms(ms)
}
\arguments{
\item{ms}{MS object}
}
\value{
numeric vector containing GC content of each sequence in ms.
GC content is computed as (# of GC bases)/(# of ACGT bases).
}
\description{
Get GC content of each sequence in an MS object
}
\examples{
require("rtfbs")
seqs <- ms(seqs=c("AAAA", "ACACACAC", "CGCCG", "ACGTACGTACGT", "CGGGGGGGGGG"),
           paste("fake", 1:5, sep=""))
gcContent.ms(seqs)
}

