% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt_user_create.R
\name{rt_user_create}
\alias{rt_user_create}
\title{Create a user}
\usage{
rt_user_create(
  name,
  password = NULL,
  email_address = NULL,
  real_name = NULL,
  organization = NULL,
  privileged = NULL,
  disabled = NULL,
  ...
)
}
\arguments{
\item{name}{(character) Optional. User name}

\item{password}{(character) The password}

\item{email_address}{(character) Optional. User email}

\item{real_name}{(character) Optional. User real name}

\item{organization}{(character) Optional. User organization}

\item{privileged}{(numeric) Optional. User privilege status}

\item{disabled}{(numeric) Optional. User disabled status}

\item{...}{Other arguments passed to \code{\link{rt_POST}}}
}
\value{
(numeric) The ID of the newly-created user
}
\description{
Create a user
}
\examples{
\dontrun{
# Create a barebones user with just a name
rt_user_create("Some Person")

# Create user that also has an email address
rt_user_create("Person", email_address = "person@example.com")
}
}
