% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removePackage.R
\name{removePackage}
\alias{removePackage}
\alias{removePackage,character-method}
\alias{removePackage,SsimLibrary-method}
\title{Removes SyncroSim package(s)}
\usage{
removePackage(ssimLibrary, packages)

\S4method{removePackage}{character}(ssimLibrary, packages)

\S4method{removePackage}{SsimLibrary}(ssimLibrary, packages)
}
\arguments{
\item{ssimLibrary}{\code{\link{SsimLibrary}} object}

\item{packages}{character string or vector of package name(s)}
}
\value{
This function invisibly returns \code{TRUE} upon success (i.e.successful
removal of the package) or \code{FALSE} upon failure.
}
\description{
Removes package(s) from a \code{\link{SsimLibrary}}.
}
\examples{
\dontrun{
# Install "stsim" and "stsimecodep" SyncroSim packages
installPackage("stsim")
installPackage("stsimecodep")

# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set up a SyncroSim Session, SsimLibrary, and Project
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)

# Add package
addPackage(myLibrary, packages = "stsim", versions = "4.0.1")
addPackage(myLibrary, packages = "stsimecodep")
packages(myLibrary)

# Remove package
removePackage(myLibrary, packages = c("stsim", "stsimecodep"))
packages(myLibrary)
}

}
\seealso{
\code{\link{packages}}
}
