% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breakpoint.R
\name{addBreakpoint}
\alias{addBreakpoint}
\alias{addBreakpoint,Scenario-method}
\title{Add a Scenario breakpoint.}
\usage{
addBreakpoint(x, transformerName, breakpointType, arguments, callback)

\S4method{addBreakpoint}{Scenario}(x, transformerName, breakpointType, arguments, callback)
}
\arguments{
\item{x}{A SyncroSim Scenario}

\item{transformerName}{A Stochastic Time Transformer (e.g. stsim_Runtime)}

\item{breakpointType}{bi: before iteration; ai: after iteration; bt:before timestep; at: after timestep}

\item{arguments}{A vector of timesteps or iterations e.g. c(1,2)}

\item{callback}{A function to be called when the breakpoint is hit}
}
\value{
A SyncroSim Scenario with an updated list of breakpoints
}
\description{
When the Scenario is run the breakpoint's callback function will be called for the specified iterations or timesteps.
}
\details{
Breakpoints are only supported for Stochastic Time Transformers.
}
\examples{
\donttest{
callbackFunction <- function(x, iteration, timestep) {
  print(paste0("Breakpoint hit: ", scenarioId(x)))
}

temp_dir <- tempdir()
myses <- session()
mylib <- ssimLibrary(name = file.path(temp_dir,"testlib"), session = myses)
myScenario <- scenario(mylib, "testScenario")

myScenario <- addBreakpoint(x= myScenario, transformerName= "stsim_Runtime", breakpointType = "bi", 
              arguments = c(1,2), callback = callbackFunction)
}
}
