% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rehreg.R
\name{rehreg}
\alias{rehreg}
\title{Random generation from extended hazard models}
\usage{
rehreg(u, formula, baseline, beta, phi, dist = NULL, data, ...)
}
\arguments{
\item{u}{a numeric vector of quantiles.}

\item{formula}{formula specifying the linear predictors.}

\item{baseline}{the name of the baseline survival distribution.}

\item{beta}{vector of regression coefficients.}

\item{phi}{vector of regression coefficients.}

\item{dist}{an alternative way to specify the baseline survival distribution.}

\item{data}{data frame containing the covariates used to generate the survival times.}

\item{...}{further arguments passed to other methods.}
}
\value{
a numeric vector containing the generated random sample.
}
\description{
Function to generate a random sample of survival data from extended hazard models.
}
\examples{
\donttest{
library(rsurv)
n <-  1000
simdata <- data.frame(
  age = rnorm(n),
  sex = sample(c("f", "m"), size = n, replace = TRUE)
) \%>\%
  mutate(
    t = rehreg(runif(n), ~ age+sex, beta = c(1, 2), phi = c(-1, 2),
                dist = "weibull", shape = 1.5, scale = 1),
    c = runif(n, 0, 10)
  ) \%>\%
  rowwise() \%>\%
  mutate(
    time = min(t, c),
    status = as.numeric(time == t)
  )
glimpse(simdata)
}

}
