% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.matrix.stapreg.R
\name{as.matrix.stapreg}
\alias{as.matrix.stapreg}
\alias{as.array.stapreg}
\alias{as.data.frame.stapreg}
\title{Extract the posterior sample via matrix}
\usage{
\method{as.matrix}{stapreg}(x, ..., pars = NULL, regex_pars = NULL)

\method{as.array}{stapreg}(x, ..., pars = NULL, regex_pars = NULL)

\method{as.data.frame}{stapreg}(x, ..., pars = NULL, regex_pars = NULL)
}
\arguments{
\item{x}{A fitted model object returned by one of the 
\pkg{rstap} modeling functions. See \code{\link{stapreg-objects}}.}

\item{...}{Ignored.}

\item{pars}{An optional character vector of parameter names.}

\item{regex_pars}{An optional character vector of \link[=grep]{regular 
expressions} to use for parameter selection. \code{regex_pars} can be used
in place of \code{pars} or in addition to \code{pars}. Currently, all
functions that accept a \code{regex_pars} argument ignore it for models fit
using optimization.}
}
\value{
A matrix, data.frame, or array, the dimensions of which depend on
  \code{pars} and \code{regex_pars}, as well as the model and estimation
  algorithm (see the Description section above).
}
\description{
The posterior sample ---the post-warmup 
draws from the posterior distribution--- can be extracted 
from a fitted model object as a matrix, data frame, or array. The 
\code{as.matrix} and \code{as.data.frame} methods merge all chains together, 
whereas the \code{as.array} method keeps the chains separate.
}
\examples{
\donttest{
if (!exists("example_model")) example(example_model)
# Extract posterior sample after MCMC
draws <- as.matrix(example_model)
print(dim(draws))

# For example, we can see that the median of the draws for the intercept 
# is the same as the point estimate rstanarm uses
print(median(draws[, "(Intercept)"]))
print(example_model$coefficients[["(Intercept)"]])

# The as.array method keeps the chains separate
draws_array <- as.array(example_model)
print(dim(draws_array)) # iterations x chains x parameters
}
}
\seealso{
\code{\link{stapreg-methods}}
}
