% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print-and-summary.R
\name{summary.stapreg}
\alias{summary.stapreg}
\alias{print.summary.stapreg}
\alias{as.data.frame.summary.stapreg}
\title{Summary method for stapreg objects}
\usage{
\method{summary}{stapreg}(object, pars = NULL, regex_pars = NULL,
  probs = NULL, waic = F, ..., digits = 1)

\method{print}{summary.stapreg}(x, digits = max(1, attr(x,
  "print.digits")), ...)

\method{as.data.frame}{summary.stapreg}(x, ...)
}
\arguments{
\item{object}{A fitted model object returned by one of the 
\pkg{rstap} modeling functions. See \code{\link{stapreg-objects}}.}

\item{pars}{An optional character vector specifying a subset of parameters to
display. Parameters can be specified by name or several shortcuts can be 
used. Using \code{pars="beta"} will restrict the displayed parameters to 
only the regression coefficients (without the intercept). \code{"alpha"} 
can also be used as a shortcut for \code{"(Intercept)"}. If the model has 
varying intercepts and/or slopes they can be selected using \code{pars = 
"varying"}.

In addition, for \code{stapmvreg} objects there are some additional shortcuts 
available. Using \code{pars = "long"} will display the 
parameter estimates for the longitudinal submodels only (excluding group-specific
pparameters, but including auxiliary parameters).
Using \code{pars = "event"} will display the 
parameter estimates for the event submodel only, including any association
parameters. 
Using \code{pars = "assoc"} will display only the 
association parameters. 
Using \code{pars = "fixef"} will display all fixed effects, but not
the random effects or the auxiliary parameters. 
 \code{pars} and \code{regex_pars} are set to \code{NULL} then all 
fixed effect regression coefficients are selected, as well as any 
auxiliary parameters and the log posterior.   

If \code{pars} is \code{NULL} all parameters are selected for a \code{stapreg}
object.}

\item{regex_pars}{An optional character vector of \link[=grep]{regular 
expressions} to use for parameter selection. \code{regex_pars} can be used
in place of \code{pars} or in addition to \code{pars}. Currently, all
functions that accept a \code{regex_pars} argument ignore it for models fit
using optimization.}

\item{probs}{For models fit using MCMC, 
an optional numeric vector of probabilities passed to 
\code{\link[stats]{quantile}}.}

\item{waic}{logical to determine whether waic should be calculated and printed with the summary object}

\item{...}{Currently ignored.}

\item{digits}{Number of digits to use for formatting numbers when printing. 
When calling \code{summary}, the value of digits is stored as the 
\code{"print.digits"} attribute of the returned object.}

\item{x}{An object of class \code{"summary.stapreg"}.}
}
\value{
The \code{summary} method returns an object of class 
  \code{"summary.stapreg"}, inheriting 
  \code{"summary.stapreg"}), which is a matrix of 
  summary statistics and 
  diagnostics, with attributes storing information for use by the
  \code{print} method. The \code{print} method for \code{summary.stapreg} or
  \code{summary.stapmvreg} objects is called for its side effect and just returns 
  its input. The \code{as.data.frame} method for \code{summary.stapreg} 
  objects converts the matrix to a data.frame, preserving row and column 
  names but dropping the \code{print}-related attributes.
}
\description{
Summaries of parameter estimates and MCMC convergence diagnostics 
(Monte Carlo error, effective sample size, Rhat).
}
\seealso{
\code{\link{prior_summary}} to extract or print a summary of the 
  priors used for a particular model.
}
