% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assets-funs.R
\name{assets_function}
\alias{assets_function}
\alias{assets_list}
\alias{assets_select}
\alias{assets_select.STACItemCollection}
\alias{assets_select.STACItem}
\alias{assets_filter}
\alias{assets_filter.STACItemCollection}
\alias{assets_filter.STACItem}
\title{Assets functions}
\usage{
assets_list(
  items,
  asset_names = NULL,
  sort = TRUE,
  gdal_vsi_resolution = TRUE,
  assets_names = deprecated()
)

assets_select(items, asset_names)

\method{assets_select}{STACItemCollection}(items, asset_names)

\method{assets_select}{STACItem}(items, asset_names)

assets_filter(items, ..., fn = NULL)

\method{assets_filter}{STACItemCollection}(items, ..., fn = NULL)

\method{assets_filter}{STACItem}(items, ..., fn = NULL)
}
\arguments{
\item{items}{a \code{STACItemCollection} object representing
the result of \verb{/stac/search}, \code{/collections/{collectionId}/items}.}

\item{asset_names}{a \code{character} with the assets names to be
filtered. If \code{NULL} (default) all assets will be returned..}

\item{sort}{a \code{logical} if true the dates will be sorted
in increasing order. By default, the dates are sorted.}

\item{gdal_vsi_resolution}{a \code{logical}  if true, gdal drivers are
included in the URL of each asset. The following schemes are supported:
HTTP/HTTPS files, S3 (AWS S3) and GS (Google Cloud Storage).}

\item{assets_names}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
use \code{asset_names} parameter instead.}

\item{...}{additional arguments. See details.}

\item{fn}{a \code{function} that will be used to filter the attributes
listed in the properties.}
}
\value{
a \code{list} with the attributes of date, bands and paths.
}
\description{
This function returns the \code{date}, \code{band} and
\code{URL} fields for each assets of an \code{STACItemCollection} object.
For the URL you can add the GDAL library drivers for the following schemes:
HTTP/HTTPS files, S3 (AWS S3) and GS (Google Cloud Storage).
}
\examples{
\donttest{
# STACItemCollection object
stac_item <- stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
 stac_search(collections = "CB4_64_16D_STK-1", limit = 100,
        datetime = "2017-08-01/2018-03-01",
        bbox = c(-48.206,-14.195,-45.067,-12.272)) \%>\%
 get_request() \%>\% items_fetch(progress = FALSE)

stac_item \%>\% assets_list(assets_names = c("EVI", "NDVI"))
}

}
