% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ext_query.R
\name{ext_query}
\alias{ext_query}
\title{Extension functions}
\usage{
ext_query(q, ...)
}
\arguments{
\item{q}{a \code{RSTACQuery} object expressing a STAC query
criteria.}

\item{...}{entries with format \code{<field> <operator> <value>}.}
}
\value{
A \code{RSTACQuery} object  with the subclass \code{ext_query} containing
 all request parameters to be passed to \code{post_request()} function.
}
\description{
The \code{ext_query()} is the \emph{exported function} of the STAC API
query extension. It can be used after a call to \code{stac_search()}
function. It allows that additional fields and operators other than those
defined in \code{stac_search()} function be used to make a complex filter.

The function accepts multiple filter criteria. Each filter entry is an
expression formed by \code{<field> <operator> <value>}, where
\code{<field>} refers to a valid item property. Supported \code{<fields>}
depends on STAC API service implementation. The users must rely on service
providers' documentation to know which properties can be used by this
extension.

The \code{ext_query()} function allows the following \code{<operators>}
\itemize{
\item \code{==} corresponds to '\code{eq}'
\item \code{!=} corresponds to '\code{neq}'
\item \code{<} corresponds to '\code{lt}'
\item \code{<=} corresponds to '\code{lte}'
\item \code{>} corresponds to '\code{gt}'
\item \code{>=} corresponds to '\code{gte}'
\item \code{\%startsWith\%} corresponds to '\code{startsWith}' and implements
a string prefix search operator.
\item \code{\%endsWith\%} corresponds to '\code{endsWith}' and implements a
string suffix search operator.
\item \code{\%contains\%}: corresponds to '\code{contains}' and implements a
string infix search operator.
\item \code{\%in\%}: corresponds to '\code{in}' and implements a vector
search operator.
}

Besides this function, the following S3 generic methods were implemented
to get things done for this extension:
\itemize{
\item The \code{endpoint()} for subclass \code{ext_query}
\item The \code{before_request()} for subclass \code{ext_query}
\item The \code{after_response()} for subclass \code{ext_query}
}
See source file \code{ext_query.R} for an example on how implement new
extensions.
}
\examples{
\donttest{
stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
  stac_search(collections = "CB4_64_16D_STK-1") \%>\%
  ext_query("bdc:tile" \%in\% "022024") \%>\%
  post_request()
}

}
\seealso{
\code{\link{stac_search}}, \code{\link{post_request}},
\code{\link{endpoint}}, \code{\link{before_request}},
\code{\link{after_response}}, \code{\link{content_response}}
}
