% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{integration}
\alias{integration}
\alias{enable}
\alias{disable}
\title{Enable/Disable RStudio Package Manager}
\usage{
enable()

disable()
}
\value{
No return value, called for side effects.
}
\description{
Functions to enable or disable RSPM repos as well as the integration of
\code{\link{install_sysreqs}} into \code{install.packages} and
\code{update.packages}. When enabled, binary packages are installed from
RSPM if available, and system requirements are transparently resolved and
installed without root privileges.
}
\details{
To enable \pkg{rspm} permanently, include the following into your
\code{.Rprofile}:

\code{suppressMessages(rspm::enable())}
}
\examples{
\dontrun{
# install 'units' and all its dependencies from the system repos
rspm::enable()
install.packages("units")

# install packages again from CRAN
rspm::disable()
install.packages("errors")
}

}
\seealso{
\code{\link{renv_init}} for \pkg{renv} projects.
}
