% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download-npgo.R
\name{download_npgo}
\alias{download_npgo}
\title{Download North Pacific Gyre Oscillation data}
\usage{
download_npgo(use_cache = FALSE, file = NULL)
}
\arguments{
\item{use_cache}{logical option to save and load from cache. If `TRUE`, results will be cached in memory
if `file` is `NULL` or on disk if `file` is not `NULL`.}

\item{file}{optional character with the full path of a file to save the data. If `cache` is `FALSE` but
`file` is not `NULL`, the results will be downloaded from the internet and saved on disk.}
}
\value{
\itemize{
\item Date: Date object that uses the first of the month as a placeholder. Date formatted as date on the first of the month because R only supports one partial of date time
\item Year: Year of Record
\item Month: Month of record
\item NPGO: North Pacific Gyre Oscillation
}
}
\description{
North Pacific Gyre Oscillation data also known as the Victoria mode
}
\examples{
\dontrun{
npgo <- download_npgo()
}

}
\references{
\url{http://www.oces.us/npgo}
}
