% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download-soi.R
\name{download_soi}
\alias{download_soi}
\title{Download Southern Oscillation Index data}
\usage{
download_soi()
}
\value{
\itemize{
\item Date: Date object that uses the first of the month as a placeholder. Date formatted as date on the first of the month because R only supports one partial of date time
\item Month: Month of record
\item Year: Year of record
\item SOI: Southern Oscillation Index
\item SOI_3MON_AVG: 3 Month Average Southern Oscillation Index
}
}
\description{
The Southern Oscillation Index is defined as the standardized difference between barometric readings at Darwin, Australia and Tahiti.
}
\examples{
\dontrun{
soi <- download_soi()
plot(x = enso$Date, y = enso$SOI, type = "l")
}

}
\references{
\url{https://www.ncdc.noaa.gov/teleconnections/enso/indicators/soi/}
}
