% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{plot_hypnogram}
\alias{plot_hypnogram}
\title{Plot a hypnogram from an events dataframe.}
\usage{
plot_hypnogram(events, labels = c("N3", "N2", "N1", "REM", "AWA"))
}
\arguments{
\item{events}{Events dataframe. Dataframe must have \code{begin} (\code{POSIXt}), \code{end} (\code{POSIXt}) and \code{event}}

\item{labels}{Sleep stages labels. Defaults to \code{c("N3","N2","N1","REM","AWA")}.}
}
\value{
a ggplot object.
}
\description{
Plot a hypnogram from an events dataframe.
}
\examples{
hypnogram <- data.frame(begin = as.POSIXlt(
c(1536967800,1536967830,1536967860),origin = "1970-01-01"))
hypnogram$end <- as.POSIXlt(c(1536967830,1536967860,1536967890), 
origin = "1970-01-01")
hypnogram$event = c("N3","N3","REM")
plot_hypnogram(hypnogram)

}
