% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary.R
\name{sc_dict}
\alias{sc_dict}
\title{Search data dictionary.}
\usage{
sc_dict(
  search_string,
  search_col = c("all", "description", "varname", "dev_friendly_name", "dev_category",
    "label", "source"),
  ignore_case = TRUE,
  limit = 10,
  confirm = FALSE,
  print_dev = FALSE,
  print_notes = FALSE,
  return_df = FALSE,
  print_off = FALSE
)
}
\arguments{
\item{search_string}{Character string for search. Can use regular
expression for search. Must escape special characters,
\code{. \ | ( ) [ \{ ^ $ * + ?}, with a doublebackslash
\code{\\\\}.}

\item{search_col}{Column to search. The default is to search all
columns.  Other options include: "varname",
"dev_friendly_name", "dev_category", "label".}

\item{ignore_case}{Search is case insensitive by default. Change to
\code{FALSE} to restrict search to exact case matches.}

\item{limit}{Only the first 10 dictionary items are returned by
default. Increase to return more values. Set to \code{Inf} to
return all items matched in search'}

\item{confirm}{Use to confirm status of variable name in
dictionary. Returns \code{TRUE} or \code{FALSE}.}

\item{print_dev}{Set to \code{TRUE} if you want to see the
developer friendly name and category used in the API call.}

\item{print_notes}{Set to \code{TRUE} if you want to see the notes
included in the data dictionary (if any).}

\item{return_df}{Return a tibble of the subset data dictionary.}

\item{print_off}{Do not print to console; useful if you only want
to return a tibble of dictionary values.}
}
\description{
This function is used to search the College Scorecard
data dictionary.
}
\examples{
sc_dict('state')
sc_dict('^st', search_col = 'varname') # variable names starting with 'st'
sc_dict('.', limit = Inf) # return full dictionary (not recommended)
}
