% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affiliation_retrieval.R
\name{affiliation_retrieval}
\alias{affiliation_retrieval}
\title{SCOPUS Affiliation Retrieval}
\usage{
affiliation_retrieval(id, identifier = c("affiliation_id", "eid"),
  http_end = NULL, ...)
}
\arguments{
\item{id}{Identifier for affiliation}

\item{identifier}{Type of identifier to use}

\item{http_end}{any additional end to http statement.
See \code{\link{generic_elsevier_api}}}

\item{...}{Arguments to be passed to \code{\link{generic_elsevier_api}}}
}
\value{
List of elements, similar to \code{\link{generic_elsevier_api}}
}
\description{
This function wraps \code{\link{generic_elsevier_api}} to give a
retrieval of an affiliation from the Elsevier Affiliation Retrieval API
}
\examples{
api_key = get_api_key(NULL, error = FALSE)
if (!is.null(api_key)){
   x = affiliation_retrieval("60006183", identifier = "affiliation_id")
}
}
\seealso{
\code{\link{generic_elsevier_api}}
}

