% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R
\name{-.rscalaBridge}
\alias{-.rscalaBridge}
\title{Operator to Make an R Object Reference}
\usage{
\method{-}{rscalaBridge}(bridge, rObject)
}
\arguments{
\item{bridge}{An rscala bridge}

\item{rObject}{An arbitrary R object}
}
\description{
This operator creates an rscala reference from an arbitrary R object.  This reference
can be passed as an argument to a method call of the embedded \code{RClient} or
may be reconstituted using the unary minus operator \code{\link{-.rscalaReference}}.
}
\examples{
\donttest{
scala(assign.name='e')      # Implicitly defines the bridge 'e'.
wrappedFunction <- e - rnorm
(-wrappedFunction)(10)
close(e)
}

}
\seealso{
\code{\link{-.rscalaReference}}
}
