% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsat_derive.R
\name{rsat_derive}
\alias{rsat_derive}
\alias{rsat_derive,rtoi,character-method}
\alias{rsat_derive,rtoi,character}
\title{Computes a remote sensing index from an \code{rtoi}}
\usage{
rsat_derive(x, variable, ...)

\S4method{rsat_derive}{rtoi,character}(
  x,
  variable,
  product,
  dates,
  fun,
  overwrite = FALSE,
  verbose = FALSE,
  suppressWarnings = TRUE,
  ...
)
}
\arguments{
\item{x}{an \code{rtoi} as the source of images.}

\item{variable}{the name of the variable.}

\item{...}{additional argument for variable deriving}

\item{product}{the name of the product from which the index is computed.}

\item{dates}{a vector of dates being considered (optional).}

\item{fun}{a \code{function} that computes the remote sensing index.}

\item{overwrite}{logical argument. If \code{TRUE}, overwrites the existing
images with the same name.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the
running steps and warnings.}

\item{suppressWarnings}{evaluates its expression in a context that ignores all warnings.}
}
\value{
nothing. The derived variables will be save in the hard drive.
Use get_stars to get the variables.
}
\description{
Combines the bands from multispectral satellite products through simple
math to highlight a process or material in the image.
}
\details{
The package contemplates some pre-defined indexes, which can be displayed
using the \code{show_variables()} function. To compute one of those, write
its name in the \code{variable} argument. Custom indexes can be
supplied through the \code{fun} argument. The function should use the
name of the bands as inputs (red, green, blue, nir, swir1, or swir2) and
return a single element. For instance, the Normalized Difference Snow
Index would be;

NDSI = function(green, swir1){
ndsi <- (green - swir1)/(green + swir1)
return(ndsi)
}
}
\examples{
\dontrun{
library(rsat)

# create a copy of pamplona in temp file
file.copy(from=system.file("ex/Pamplona",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

# load example rtoi
pamplona <- read_rtoi(file.path(tempdir(),"Pamplona"))

rsat_list_data(pamplona)
# show prefedined varibles
show_variables()
rsat_derive(pamplona, "NDVI", product = "mod09ga")
# now NDVI is processed
rsat_list_data(pamplona)

# ad-hoc variable
NDSI = function(green, swir1){
ndsi <- (green - swir1)/(green + swir1)
return(ndsi)
}
rsat_derive(pamplona, "NDSI", product = "mod09ga",fun=NDSI)
# now NDVI is processed
rsat_list_data(pamplona)
plot(pamplona, product="mod09ga",variable="NDSI")
}
}
