% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsat_smoothing_images.R
\name{rsat_smoothing_images}
\alias{rsat_smoothing_images}
\alias{rsat_smoothing_images,rtoi,character-method}
\alias{rsat_smoothing_images,rtoi,character}
\alias{rsat_smoothing_images,SpatRaster,character-method}
\title{Fill data gaps and smooth outliers in a time series of satellite images}
\usage{
rsat_smoothing_images(x, method, ...)

\S4method{rsat_smoothing_images}{rtoi,character}(
  x,
  method,
  product = "ALL",
  satellite = "ALL",
  stage = "ALL",
  variable = "ALL",
  test.mode = FALSE,
  ...
)

\S4method{rsat_smoothing_images}{SpatRaster,character}(x, method, ...)
}
\arguments{
\item{x}{\code{rtoi}, \code{RastespatRaster} or \code{RasterBrick} containing
a time series of satellite images.}

\item{method}{character argument. Defines the method used
for processing the images, e.a. "IMA".}

\item{...}{arguments for nested functions:
\itemize{
  \item \code{Img2Fill}  a \code{vector} defining the
  images to be filled/smoothed.
  \item \code{r.dates} a \code{vector} of dates for the layers in \code{x}.
Mandatory when layer names of \code{x} do not contain their
 capturing dates
"\code{YYYYJJJ}" format.
  \item \code{nDays} a \code{numeric} argument with the number
  of previous and subsequent days of the temporal neighborhood.
  \item \code{nYears} a \code{numeric} argument with the number
  of previous and subsequent years of the temporal neighborhood.
  \item \code{aFilter} a \code{vector} of lower and upper
  quantiles defining the outliers in the anomalies. Ex. c(0.05,0.95).
  \item \code{fact} a \code{numeric} argument specifying the aggregation
  factor of the anomalies.
  \item \code{fun} a \code{function} used to aggregate the
  image of anomalies. Both \code{mean} (default) or \code{median} are
  accepted.
  \item \code{snow.mode} logical argument. If \code{TRUE},
  the process is parallelized using the functionalities from the `
  \code{raster}' package.
  \item \code{predictSE} calculate the standard error instead
  the prediction.
  \item \code{factSE} the \code{fact} used in the standard error
  prediction.
  \item \code{out.name} the name of the folder containing the
  smoothed/filled images when saved in the Hard Disk Device (HDD).
  \item \code{only.na} logical argument. If \code{TRUE}
  only fills the \code{NA} values.
\code{FALSE}  by default.
}}

\item{product}{character argument. The name of the product to
be processed. Check the name of the parameter with \code{\link{rsat_list_data}}
function. Check the name of the parameter with
\code{\link{rsat_list_data}} function. By default, "ALL".}

\item{satellite}{character argument. The name of the satellite to
be processed. Check the name of the parameter with
\code{\link{rsat_list_data}} function. By default, "ALL".}

\item{stage}{character argument. The name of the processed stage
of the data. Check the name of the parameter with
\code{\link{rsat_list_data}} function. By default, "ALL".}

\item{variable}{character argument.The name of the variable to
be processed. Check the name of the parameter with
\code{\link{rsat_list_data}} function. By default, "ALL".}

\item{test.mode}{logical argument. If \code{TRUE}, the function runs some
lines to test \code{rsat_smoothing_images} with rtoi object.}
}
\value{
a \code{RastespatRaster} with the filled/smoothed images.
}
\description{
\code{apply_ima} is the implementation of a spatio-temporal method
called Interpolation of Mean Anomalies(IMA) for gap filling and smoothing
satellite data \insertCite{militino2019interpolation}{rsat}.
\code{smoothing_images} is the implementation of a spatio temporal method
called image mean anomaly (IMA) for gap filling and smoothing satellite
data \insertCite{militino2019interpolation}{rsat}.
}
\details{
This filling/smoothing method was developed by
\insertCite{militino2019interpolation;textual}{rsat}. IMA fills the gaps
borrowing information from an adaptable temporal neighborhood. Two
parameters determine the size of the neighborhood; the number of days
 before and after the target image (\code{nDays}) and the number of previous
and subsequent years (\code{nYears}). Both parameters should be adjusted
based on the temporal resolution of the of the time-series of images. We
recommend that the neighborhood extends over days rather than years, when
there is little resemblance between seasons. Also, cloudy series may require
larger neighborhoods.

IMA gives the following steps; (1) creates a representative image from the
temporal neighborhood of the target image (image to be filled/smoothed) e.g.,
doing the mean, median, etc. for each pixel's time-series (\code{fun}), (2)
the target and representative images are subtracted giving an image of
anomalies, (3) the anomalies falling outside the quantile limits
(\code{aFilter}) are considered outliers and therefore removed, (4) it
aggregates the anomaly image into a coarser resolution (\code{fact}) to
reveal potential spatial dependencies, (5) the procedure fits a spatial
model (thin plate splines or TPS) to the anomalies which is then used to
interpolate the values at the original resolution, and (6) the output
is the sum of the interpolated anomalies and the average image.
}
\examples{
## Smooth data in rtoi
library(rsat)
require(terra)

# create a copy of pamplona in temp file
file.copy(from=system.file("ex/PamplonaDerived",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

# load example rtoi
pamplona <- read_rtoi(file.path(tempdir(),"PamplonaDerived"))
rsat_smoothing_images(pamplona,
                      method = "IMA",
                      variable="NDVI"
)
rsat_list_data(pamplona)
# get smoothed
smoothed <- rsat_get_SpatRaster(pamplona,p="mod09ga",v="NDVI",s="IMA")
plot(smoothed)

# get original
original <- rsat_get_SpatRaster(pamplona,p="mod09ga",v="NDVI",s="variables")
plot(original)
plot(smoothed[[1]]-original[[1]])

## smooth user defined SpatRaster dataset
require(terra)
data(ex.ndvi.navarre)

# load an example of NDVI time series in Navarre
ex.ndvi.navarre <- rast(ex.ndvi.navarre)
# the raster stack with the date in julian format as name
plot(ex.ndvi.navarre)

# smoothin and fill all the time series
tiles.mod.ndvi.filled <- rsat_smoothing_images(ex.ndvi.navarre,
  method = "IMA"
)
# show the filled images
plot(tiles.mod.ndvi.filled)

# plot comparison of the cloud and the filled images
tiles.mod.ndvi.comp <- c(
  ex.ndvi.navarre[[1]], tiles.mod.ndvi.filled[[1]],
  ex.ndvi.navarre[[2]], tiles.mod.ndvi.filled[[2]]
)
plot(tiles.mod.ndvi.comp)
}
\references{
\insertRef{militino2019interpolation}{rsat}
}
