% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_intervals.R
\name{reg_intervals}
\alias{reg_intervals}
\title{A convenience function for confidence intervals with linear-ish parametric models}
\usage{
reg_intervals(
  formula,
  data,
  model_fn = "lm",
  type = "student-t",
  times = NULL,
  alpha = 0.05,
  filter = term != "(Intercept)",
  keep_reps = FALSE,
  ...
)
}
\arguments{
\item{formula}{An R model formula with one outcome and at least one predictor.}

\item{data}{A data frame.}

\item{model_fn}{The model to fit. Allowable values are "lm", "glm",
"survreg", and "coxph". The latter two require that the \code{survival} package
be installed.}

\item{type}{The type of bootstrap confidence interval. Values of "student-t" and
"percentile" are allowed.}

\item{times}{A single integer for the number of bootstrap samples. If left
NULL, 1,001 are used for t-intervals and 2,001 for percentile intervals.}

\item{alpha}{Level of significance.}

\item{filter}{A logical expression used to remove rows from the final result, or \code{NULL} to keep all rows.}

\item{keep_reps}{Should the individual parameter estimates for each bootstrap
sample be retained?}

\item{...}{Options to pass to the model function (such as \code{family} for \code{glm()}).}
}
\value{
A tibble with columns "term", ".lower", ".estimate", ".upper",
".alpha", and ".method". If \code{keep_reps = TRUE}, an additional list column
called ".replicates" is also returned.
}
\description{
A convenience function for confidence intervals with linear-ish parametric models
}
\examples{
\donttest{
set.seed(1)
reg_intervals(mpg ~ I(1/sqrt(disp)), data = mtcars)

set.seed(1)
reg_intervals(mpg ~ I(1/sqrt(disp)), data = mtcars, keep_reps = TRUE)
}
}
\references{
Davison, A., & Hinkley, D. (1997). \emph{Bootstrap Methods and their
Application}. Cambridge: Cambridge University Press.
doi:10.1017/CBO9780511802843

\emph{Bootstrap Confidence Intervals},
\url{https://rsample.tidymodels.org/articles/Applications/Intervals.html}
}
\seealso{
\code{\link[=int_pctl]{int_pctl()}}, \code{\link[=int_t]{int_t()}}
}
