% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelSample.R
\name{labelSample}
\alias{labelSample}
\title{labelSample}
\usage{
labelSample(xy = xy, agg.radius = agg.radius, nr.points = NULL,
  nr.pixels = NULL, pixel.res = pixel.res)
}
\arguments{
\item{xy}{Object of class \emph{SpatialPoints} of \emph{SpatialPointsDataFrame}.}

\item{agg.radius}{Minimum radius for pixel aggregation. Unit depends on the projection of the data.}

\item{nr.points}{Minimum number of samples per pixel.}

\item{nr.pixels}{Minimum number of pixels per region.}

\item{pixel.res}{Pixel resolution or a valid raster layer.}
}
\value{
A \emph{vector} of unique identifiers assigning each point in \emph{xy} to their correspondent pixel region. Filtered observations are returned as \emph{NA}.
}
\description{
{Pixel-based labeling of spatially connected groups of samples for splitting them between training and validation.}
}
\details{
{First, the samples are converted to pixel coordinates and removes pixels with a corresponding number of points greater
than \emph{nr.points}. Then, if \emph{nr.pixels} is set, the connectivity between neighboring samples is evaluated. Internally, the
function will label groups of pixels based on their connectivity and regions with a pixel count smaller than the one specified by
\emph{nr.pixels} are excluded. Then, the algorithm aggregates nearby regions using a dilation algorithm within the radius specified
by \emph{agg.radius} and proceeds to reliable the pixels covered by samples. Finally, this information is used to label the original
samples provided by \emph{xy} based on their corresponding pixel coordinates. This analysis is based on the spatial extent of \emph{xy}
and a given pixel resolution (\emph{pixel.res}). Alternatively, the user may assign a raster object to \emph{pixel.res}.}
}
\examples{
{

 require(raster)

 # read raster data
 r <- raster(system.file('extdata', '2013-07-16_ndvi.tif', package="rsMove"))

 # read movement data
 data(shortMove)

 # derive region labels
 labels <- labelSample(xy=shortMove, agg.radius=90, nr.pixels=2, pixel.res=30)

}
}
\references{
\href{10.1002/rse2.70}{Remelgado, R., Leutner, B., Safi, K., Sonnenschein, R., Kuebert, C. and Wegmann, M. (2017), Linking animal movement and remote sensing - mapping resource suitability from a remote sensing perspective. Remote Sens Ecol Conserv.}
}
\seealso{
\code{\link{sampleMove}} \code{\link{hotMove}}
}
