% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proSat.R
\name{proSat}
\alias{proSat}
\title{proSat}
\usage{
proSat(t.var = NULL, xy = NULL, o.time = NULL, d.path = NULL,
  p.raster = FALSE, p.res = NULL, user.cred = NULL, pad = 10)
}
\arguments{
\item{t.var}{Target variable.}

\item{xy}{Object from which an extent can be derived.}

\item{o.time}{Object of class \emph{Date}.}

\item{d.path}{Output data path for downloaded data.}

\item{p.raster}{Logical. Should the output be re-projected?}

\item{p.res}{Target pixel resolution (if p.raster is TRUE).}

\item{user.cred}{Two element character vector containing username and password.}

\item{pad}{Padding expressed in number of pixels. Used when re-projecting and resampling.}
}
\value{
One or multiple raster objects.
}
\description{
Interface to download and process satelite data.
}
\details{
{Downloads and pre-processes pre-selected satellite datasets That provide ecologically
meaningful variables. \emph{xy} is required to define a reference extent for which the data will
be downloaded and croped. If \emph{p.raster} is TRUE, the function will also re-project the output
to the projection of \emph{xy}. Note that \emph{xy} does not required reprojection a priori. The
function will find the approapriate projection to use when deriving a reference extent. If \emph{p.raster}
is TRUE \emph{p.res} is also required to determine the output pixel resolution. The outputs are presented
in GTiff format and are croped and masked by default. Note that the download files might not correspond to
the dates supplied through \emph{o.time}. The function will consider the temporal resolution of the target
dataset and compare the possible and the requested dates. If a requested date is not found, the
function will instead provide the closest image time. As a consequence, the number of downloaded
files might be lesser than the number of dates. The function will inform the user on this by providing
a list object which contains the downloaded dates (\emph{$date}) as well as the path for the correspondent
image (\emph{$path}).}
}
\note{
{To consult the list of provided variables, run the function without specifying any input.
This will provide information on the variables, variable codes (used in \emph{t.var}), temporal and
spatial resolution and the sensor of origin. Some variables might require login credentials. Check
the table to know which credentials to use and assign them through \emph{user.cred}.}
}
\examples{
{

 # return list of variables
 modis.var <- proSat()

}
}
\seealso{
\code{\link{getEnv}} \code{\link{imgInt}} \code{\link{dataQuery}}
}
