% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelApply.R
\name{modelApply}
\alias{modelApply}
\title{modelApply}
\usage{
modelApply(model, img, fun = NULL)
}
\arguments{
\item{model}{List object as provided by \emph{moveModel()}.}

\item{img}{Object of class \emph{RasterLayer}, \emph{RasterStack} or \emph{RasterBrick}.}

\item{fun}{Function that specifies how the model should be applied.}
}
\value{
A \emph{Raster}.
}
\description{
Apply a model or an ensemble of models to raster data.
}
\details{
{The function uses the output of \emph{moveModel()}. If this contains a 
list of models from multiple runs, the function creates a stack of predictions 
and summarizes it on a pixel-by-pixel basis using a weighted mean. The weights 
are defined by the average performance for \emph{presence} and \emph{background} 
samples in each iteration.}
}
\examples{
\dontrun{
 
 require(raster)
 
 # read remote sensing data
 file <- list.files(system.file('extdata', '', package="rsMove"), 'tc.*tif', full.names=TRUE)
 rsStk <- stack(file)
 
 # read movement data
 moveData <- read.csv(system.file('extdata', 'konstanz_20130805-20130811.csv', package="rsMove"))
 moveData <- SpatialPointsDataFrame(moveData[,1:2], moveData, proj4string=crs(rsStk))
 
 # retrieve remote sensing data for samples
 rsQuery <- dataQuery(xy=moveData,img=rsStk, remove.dup=TRUE)
 
 # identify unique sample regions
 label <- labelSample(xy=rsQuery, rad=90, npx=1, pxr=rsStk)
 
 # select background samples
 ind <- which(label>0) # selected samples
 bSamples <- backSample(xy=moveData[ind,], rid=label[ind], img=rsStk, nb=4000, method='pca')
 
 # derive model predictions
 fun <- function(x,y) {train(x, y, method="rf", trControl=trainControl(method='oob'))}
 p.model <- moveModel(p.data=rsQuery@data, a.data=bSamples@data, label=label, fun=fun, nruns=1)

 # derive prediction from model ensemble
 fun <- function(x,y) {predict(x, y, type='prob')[[1]]$`1`}
 prob <- modelApply(p.model, rsStk, fun=fun)
 
 # see output
 plot(prob)
 
}
}
\seealso{
\code{\link{segRaster}} \code{\link{moveModel}}
}
