% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_img.R
\name{add_img}
\alias{add_img}
\title{Add plot into a document object}
\usage{
add_img(mydoc, plotstring, width = 7, height = 5, units = "in",
  res = 300, format = "emf", ...)
}
\arguments{
\item{mydoc}{A document object}

\item{plotstring}{An string of R code encoding plot}

\item{width}{the width of the device.}

\item{height}{the height of the device.}

\item{units}{The units in which height and width are given. Can be px (pixels, the default), in (inches), cm or mm.}

\item{res}{The nominal resolution in ppi which will be recorded in the bitmap file, if a positive integer. Also used for units other than the default, and to convert points to pixels.}

\item{format}{plot format}

\item{...}{additional arguments passed to png()}
}
\value{
a document object
}
\description{
Add plot into a document object
}
\examples{
require(officer)
require(rrtable)
require(magrittr)
require(flextable)
read_pptx() \%>\% add_text(title="Add image") \%>\% add_img("plot(mtcars)",format="png",res=300)
}
