/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.json;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.io.PeekReader;
import org.openjena.atlas.json.JsonObject;
import org.openjena.atlas.json.JsonValue;
import org.openjena.atlas.json.io.JSONHandler;
import org.openjena.atlas.json.io.JSONMaker;
import org.openjena.atlas.json.io.JsonWriter;
import org.openjena.atlas.json.io.parser.JSONParser;

public class JSON {
    private static final boolean useJavaCC = false;

    public static JsonObject parse(InputStream input) {
        JSONMaker maker = new JSONMaker();
        JSON._parse(input, maker);
        return (JsonObject)maker.jsonValue();
    }

    public static JsonObject parse(String string) {
        return JSON._parse(new StringReader(string));
    }

    public static JsonValue parseAny(InputStream input) {
        JSONMaker maker = new JSONMaker();
        JSON._parseAny(input, maker);
        return maker.jsonValue();
    }

    public static JsonValue parseAny(String string) {
        return JSON._parseAny(new StringReader(string));
    }

    public static JsonObject read(String filename) {
        try {
            PeekReader r = PeekReader.makeUTF8(new FileInputStream(filename));
            return JSON._parse(r);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("File not found: " + filename);
        }
    }

    public static JsonValue readAny(String filename) {
        try {
            PeekReader r = PeekReader.makeUTF8(new FileInputStream(filename));
            return JSON._parseAny(r);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("File not found: " + filename);
        }
    }

    private static JsonObject _parse(Reader r) {
        JSONMaker maker = new JSONMaker();
        JSON._parse(r, maker);
        return (JsonObject)maker.jsonValue();
    }

    private static JsonValue _parseAny(Reader r) {
        JSONMaker maker = new JSONMaker();
        JSON._parseAny(r, maker);
        return maker.jsonValue();
    }

    private static void _parse(Reader r, JSONMaker maker) {
        JSONParser.parse(r, (JSONHandler)maker);
    }

    private static void _parseAny(Reader r, JSONMaker maker) {
        JSONParser.parseAny(r, (JSONHandler)maker);
    }

    private static void _parse(InputStream r, JSONMaker maker) {
        JSONParser.parse(r, (JSONHandler)maker);
    }

    private static void _parseAny(InputStream r, JSONMaker maker) {
        JSONParser.parseAny(r, (JSONHandler)maker);
    }

    public static void write(OutputStream output, JsonValue jValue) {
        JsonWriter w = new JsonWriter(output);
        jValue.visit(w);
    }

    public static void write(IndentedWriter output, JsonValue jValue) {
        JsonWriter w = new JsonWriter(output);
        jValue.visit(w);
    }

    public static void write(JsonValue jValue) {
        JSON.write(IndentedWriter.stdout, jValue);
        IndentedWriter.stdout.flush();
    }
}

