/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIter;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRepeatApply;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryIterBlockTriplesQH
extends QueryIterRepeatApply {
    protected BasicPattern pattern;

    public static QueryIterator create(QueryIterator input, BasicPattern pattern, ExecutionContext cxt) {
        return new QueryIterBlockTriplesQH(input, pattern, cxt);
    }

    protected QueryIterBlockTriplesQH(QueryIterator input, BasicPattern pattern, ExecutionContext cxt) {
        super(input, cxt);
        this.pattern = pattern;
    }

    @Override
    public QueryIterator nextStage(Binding binding) {
        return new StagePattern(binding, this.pattern, this.getExecContext());
    }

    private static void compilePattern(Query graphQuery, List<Triple> pattern, Binding presets, Set<Var> vars) {
        if (pattern == null) {
            return;
        }
        ListIterator<Triple> iter = pattern.listIterator();
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            t = Substitute.substitute(t, presets);
            if (vars != null) {
                if (t.getSubject().isVariable()) {
                    vars.add(Var.alloc(t.getSubject()));
                }
                if (t.getPredicate().isVariable()) {
                    vars.add(Var.alloc(t.getPredicate()));
                }
                if (t.getObject().isVariable()) {
                    vars.add(Var.alloc(t.getObject()));
                }
            }
            graphQuery.addMatch(t);
        }
    }

    private static void compileConstraints(Query graphQuery, List<?> constraints) {
        Log.warn(QueryIterBlockTriplesQH.class, "Call to compileConstraints for Jena Expressions");
    }

    public static Var[] projectionVars(Set<Var> vars) {
        Var[] result = new Var[vars.size()];
        int i = 0;
        Iterator<Var> iter = vars.iterator();
        while (iter.hasNext()) {
            Var n;
            result[i] = n = iter.next();
            ++i;
        }
        return result;
    }

    private static Binding graphResultsToBinding(Binding parent, Domain d, Var[] projectionVars) {
        BindingMap binding = new BindingMap(parent);
        for (int i = 0; i < projectionVars.length; ++i) {
            Var var = projectionVars[i];
            Node n = d.get(i);
            if (n == null) continue;
            binding.add(var, n);
        }
        return binding;
    }

    @Override
    protected void details(IndentedWriter out, SerializationContext sCxt) {
        out.print(Utils.className(this));
        out.println();
        out.incIndent();
        FmtUtils.formatPattern(out, this.pattern, sCxt);
        out.decIndent();
    }

    static class StagePattern
    extends QueryIter {
        ClosableIterator<Domain> graphIter;
        Binding binding;
        Var[] projectionVars;

        public StagePattern(Binding binding, BasicPattern pattern, ExecutionContext qCxt) {
            super(qCxt);
            this.binding = binding;
            QueryHandler qh = qCxt.getActiveGraph().queryHandler();
            Query graphQuery = new Query();
            HashSet<Var> vars = new HashSet<Var>();
            QueryIterBlockTriplesQH.compilePattern(graphQuery, pattern.getList(), binding, vars);
            this.projectionVars = QueryIterBlockTriplesQH.projectionVars(vars);
            BindingQueryPlan plan = qh.prepareBindings(graphQuery, (Node[])this.projectionVars);
            this.graphIter = plan.executeBindings();
            if (this.graphIter == null) {
                Log.warn(this, "Graph Iterator is null");
            }
        }

        protected boolean hasNextBinding() {
            boolean isMore = this.graphIter.hasNext();
            return isMore;
        }

        protected Binding moveToNextBinding() {
            Domain d = (Domain)this.graphIter.next();
            Binding b = QueryIterBlockTriplesQH.graphResultsToBinding(this.binding, d, this.projectionVars);
            return b;
        }

        protected void closeIterator() {
            if (!this.isFinished()) {
                if (this.graphIter != null) {
                    this.graphIter.close();
                }
                this.graphIter = null;
            }
        }
    }
}

