/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalTypeException;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;

public class E_Add
extends ExprFunction2 {
    private static final String printName = "add";
    private static final String symbol = "+";

    public E_Add(Expr left, Expr right) {
        super(left, right, printName, symbol);
    }

    public NodeValue eval(NodeValue x, NodeValue y) {
        if (ARQ.isStrictMode()) {
            return XSDFuncOp.add(x, y);
        }
        if (x.isString() && y.isString()) {
            return NodeValue.makeString(x.asString() + y.asString());
        }
        if (!x.isNumber() || !y.isNumber()) {
            throw new ExprEvalTypeException("Operator '+' requires two numbers or two strings: got: " + x + " and " + y);
        }
        return XSDFuncOp.add(x, y);
    }

    public Expr copy(Expr e1, Expr e2) {
        return new E_Add(e1, e2);
    }
}

