/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.mgt;

import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;

public class ContextMBean
implements DynamicMBean {
    private final Context context;

    public ContextMBean(Context context) {
        this.context = context;
    }

    private Object getAsString(String name) {
        return this.context.getAsString(Symbol.create(name));
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.getAsString(attribute);
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList x = new AttributeList();
        for (String k : attributes) {
            Attribute a = new Attribute(k, this.getAsString(k));
            x.add(a);
        }
        return x;
    }

    public MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] attrInfo = new MBeanAttributeInfo[this.context.size()];
        int idx = 0;
        for (Symbol sk : this.context.keys()) {
            Object obj = this.context.get(sk);
            boolean settable = false;
            if (obj instanceof String) {
                settable = true;
            }
            if (obj instanceof Boolean) {
                settable = true;
            }
            if (obj instanceof Integer) {
                settable = true;
            }
            MBeanAttributeInfo attr = new MBeanAttributeInfo(sk.getSymbol(), "java.lang.String", sk.getSymbol(), true, settable, false);
            attrInfo[idx++] = attr;
        }
        MBeanInfo info = new MBeanInfo(this.getClass().getName(), "ARQ global context", attrInfo, null, null, null);
        return info;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.context.set(Symbol.create(attribute.getName()), attribute.getValue());
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList results = new AttributeList();
        for (Object obj : attributes) {
            Attribute a = (Attribute)obj;
            Object value = a.getValue();
            Object oldValue = this.getAsString(a.getName());
            try {
                this.setAttribute(a);
            }
            catch (Exception ex) {
                // empty catch block
            }
            results.add(new Attribute(a.getName(), this.getAsString(a.getName())));
        }
        return results;
    }
}

