% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/natural_join.R
\name{natural_join}
\alias{natural_join}
\title{Make a natural_join node.}
\usage{
natural_join(a, b, ..., by, jointype = "INNER", env = parent.frame())
}
\arguments{
\item{a}{source to select from.}

\item{b}{source to select from.}

\item{...}{force later arguments to bind by name}

\item{by}{character, set of columns to match.  If by is a named character vector the right table will have columns renamed.}

\item{jointype}{type of join ('INNER', 'LEFT', 'RIGHT', 'FULL').}

\item{env}{environment to look to.}
}
\value{
natural_join node.
}
\description{
Natural join is a join by identity on all common columns specified in the \code{by}
argument.
Any common columns not specified in the \code{by} argument
are coalesced into a single column preferring the first or "a" table.
}
\examples{

if(requireNamespace("DBI", quietly = TRUE) &&
   requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(),
                          ":memory:")

  d1 <- rq_copy_to(
    my_db, 'd1',
    build_frame(
      "key", "val", "val1" |
        "a"  , 1  ,  10    |
        "b"  , 2  ,  11    |
        "c"  , 3  ,  12    ))
  d2 <- rq_copy_to(
    my_db, 'd2',
    build_frame(
      "key", "val", "val2" |
        "a"  , 5  ,  13    |
        "b"  , 6  ,  14    |
        "d"  , 7  ,  15    ))

  # key matching join
  optree <- natural_join(d1, d2,
                         jointype = "LEFT", by = 'key')
  execute(my_db, optree) \%.>\%
    print(.)

  DBI::dbDisconnect(my_db)
}

}
