% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relop.R
\name{column_names}
\alias{column_names}
\title{Return column names}
\usage{
column_names(x, ...)
}
\arguments{
\item{x}{rquery operation tree.}

\item{...}{generic additional arguments}
}
\value{
vector of column names
}
\description{
Return column names
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d1 <- rq_copy_to(my_db, 'd1',
                    data.frame(AUC = 0.6, R2 = 0.2))
  d2 <- rq_copy_to(my_db, 'd2',
                    data.frame(AUC = 0.6, D = 0.3))
  optree <- natural_join(d1, d2, by = "AUC")
  cat(format(optree))
  print(column_names(optree))
  DBI::dbDisconnect(my_db)
}

}
