% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relop.R
\name{to_sql}
\alias{to_sql}
\title{Return SQL implementation of operation tree.}
\usage{
to_sql(x, db, ..., limit = NULL, source_limit = NULL,
  indent_level = 0, tnum = mk_tmp_name_source("tsql"),
  append_cr = TRUE, using = NULL)
}
\arguments{
\item{x}{rquery operation tree.}

\item{db}{DBI database handle or rquery_db_info object.}

\item{...}{generic additional arguments (not used).}

\item{limit}{numeric if not NULL limit result to this many rows.}

\item{source_limit}{numeric if not NULL limit sources to this many rows.}

\item{indent_level}{level to indent.}

\item{tnum}{temp sub-query name generator.}

\item{append_cr}{logical if TRUE end with CR.}

\item{using}{character, if not NULL set of columns used from above.}
}
\value{
SQL command
}
\description{
Add to last argument and pass all others through.
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d1 <- rq_copy_to(my_db, 'd1',
                    data.frame(AUC = 0.6, R2 = 0.2))
  d2 <- rq_copy_to(my_db, 'd2',
                    data.frame(AUC = 0.6, D = 0.3))
  optree <- natural_join(d1, d2, by = "AUC")
  cat(format(optree))
  print(to_sql(optree, my_db))
  DBI::dbDisconnect(my_db)
}

}
\seealso{
\code{\link{db_td}}, \code{\link{materialize}}, \code{\link{execute}}, \code{\link{rq_copy_to}}, \code{\link{mk_td}}
}
