% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{project_se}
\alias{project_se}
\title{project data by grouping, and adding aggregate columns.}
\usage{
project_se(source, groupby, assignments, env = parent.frame())
}
\arguments{
\item{source}{source to select from.}

\item{groupby}{grouping columns.}

\item{assignments}{new column assignment expressions.}

\item{env}{environment to look for values in.}
}
\value{
project node.
}
\description{
project data by grouping, and adding aggregate columns.
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(),
                          ":memory:")
  d <- dbi_copy_to(
    my_db, 'd',
    data.frame(group = c('a', 'a', 'b', 'b'),
               val = 1:4,
               stringsAsFactors = FALSE))

  op_tree <- d \%.>\%
    project_se(., "group", "vmax" := "max(val)")
  cat(format(op_tree))
  sql <- to_sql(op_tree, my_db)
  cat(sql)
  execute(my_db, op_tree) \%.>\%
     print(.)

  op_tree <- d \%.>\%
    project_se(., NULL, "vmax" := "max(val)")
  cat(format(op_tree))
  sql <- to_sql(op_tree, my_db)
  cat(sql)
  execute(my_db, op_tree) \%.>\%
     print(.)

  DBI::dbDisconnect(my_db)
}

}
