% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/if_else_block.R
\name{if_else_op}
\alias{if_else_op}
\title{Simulate a per-row block-\code{if(){}else{}}.}
\usage{
if_else_op(source, testexpr, ..., thenexprs = NULL, elseexprs = NULL)
}
\arguments{
\item{source}{optree relop node or data.frame.}

\item{testexpr}{character containing the test expression.}

\item{...}{force later arguments to bind by name.}

\item{thenexprs}{named character then assignments (altering columns, not creating).}

\item{elseexprs}{named character else assignments (altering columns, not creating).}
}
\value{
operator tree or data.frame.
}
\description{
This device uses expression-\code{ifelse(,,)} to simulate the
more powerful per-row block-\code{if(){}else{}}.  The difference is
expression-\code{ifelse(,,)} can choose per-row what value to express,
whereas block-\code{if(){}else{}} can choose per-row where to assign multiple
values. By simulation we mean: a sequence of quoted mutate expressions
are emitted that implement the transform.  These expressions can then
be optimized into a minimal number of no-dependency
blocks by \code{\link{extend_se}} for efficient execution.
The idea is the user can write legible code in this notation, and
the translation turns it into safe and efficient code suitable for
execution either on \code{data.frame}s or at a big data scale using
\code{RPostgreSQL} or \code{sparklyr}.
}
\details{
Note: \code{ifebtest_*}
is a reserved column name for this procedure.
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  # Example: clear one of a or b in any row where both are set.
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d <- dbi_copy_to(
    my_db,
    'd',
    data.frame(i = c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
               a = c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1),
               b = c(0, 1, 0, 1, 1, 1, 1, 1, 1, 1),
               edited = NA),
    temporary=TRUE, overwrite=TRUE)

  optree <- d \%.>\%
    if_else_op(.,
               testexpr = qe((a+b)>1),
               thenexprs = qae(a := 0,
                               b := 0,
                               edited := 1),
               elseexprs = qae(edited := 0))
  cat(format(optree))

  sql <- to_sql(optree, my_db)
  cat(sql)

  print(DBI::dbGetQuery(my_db, sql))

  DBI::dbDisconnect(my_db)
}


}
\seealso{
\code{\link{if_else_block}}
}
