% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theta_join.R
\name{theta_join_se}
\alias{theta_join_se}
\title{Make a theta_join node.}
\usage{
theta_join_se(a, b, expr, ..., jointype = "INNER", suffix = c("_a", "_b"),
  env = parent.frame())
}
\arguments{
\item{a}{source to select from.}

\item{b}{source to select from.}

\item{expr}{quoated join condition}

\item{...}{force later arguments to be by name}

\item{jointype}{type of join ('INNER', 'LEFT', 'RIGHT', 'FULL').}

\item{suffix}{character length 2, suffices to disambiguate columns.}

\item{env}{environment to look for values in.}
}
\value{
theta_join node.
}
\description{
Theta join is a join on an arbitrary predicate.
}
\examples{

my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
d1 <- dbi_copy_to(my_db, 'd1',
                 data.frame(AUC = 0.6, R2 = 0.2))
d2 <- dbi_copy_to(my_db, 'd2',
                 data.frame(AUC2 = 0.4, R2 = 0.3))
eqn <- theta_join_se(d1, d2, "AUC >= AUC2")
cat(format(eqn))
sql <- to_sql(eqn, my_db)
cat(sql)
DBI::dbGetQuery(my_db, sql)
DBI::dbDisconnect(my_db)

}
