% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_opal.R
\name{publish_course}
\alias{publish_course}
\title{Publish a course on LMS Opal}
\usage{
publish_course(
  course_id,
  api_user = NULL,
  api_password = NULL,
  endpoint = NULL
)
}
\arguments{
\item{course_id}{\itemize{
\item A string value of the number of course (Ressourcen-ID).
}}

\item{api_user}{A character value of the username in the OPAL.}

\item{api_password}{A character value of the password in the OPAL.}

\item{endpoint}{A string of endpoint of LMS Opal; by default it is got from
environment variable \code{RQTI_API_ENDPOINT}. To set a global environment
variable, you need to call
\code{Sys.setenv(RQTI_API_ENDPOINT='xxxxxxxxxxxxxxx')} or you can put these
command into .Renviron.}
}
\value{
Status code.
}
\description{
Publish a course on LMS Opal
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
   publish_course("89068111333293")
\dontshow{\}) # examplesIf}
}
