% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rpt.R
\name{plot.rpt}
\alias{plot.rpt}
\title{Plot a rpt object}
\usage{
\method{plot}{rpt}(x, grname = names(x$ngroups), scale = c("link",
  "original"), type = c("boot", "permut"), main = NULL, breaks = "FD",
  xlab = NULL, ...)
}
\arguments{
\item{x}{An rpt object returned from one of the rpt functions.}

\item{grname}{The name of the grouping factor to plot.}

\item{scale}{Either "link" or "original" scale results for results of non-Gaussian functions.}

\item{type}{Either "boot" or "permut" for plotting the results of bootstraps or permutations.}

\item{main}{Plot title}

\item{breaks}{hist() argument}

\item{xlab}{x-axis title}

\item{\dots}{Additional arguments to the hist() function for customized plotting.}
}
\value{
A histogram of the distribution of bootstrapping or permutation test estimates of the 
repeatability including a confidence interval (CI).
}
\description{
Plots the distribution of repeatability estimates from bootstrapping and permutation tests.
}
\references{
Nakagawa, S. & Schielzeth, H. (2010) \emph{Repeatability for Gaussian and 
non-Gaussian data: a practical guide for biologists}. Biological Reviews 85: 935-956
}
\author{
Holger Schielzeth  (holger.schielzeth@uni-jena.de), 
        Shinichi Nakagawa (s.nakagawa@unsw.edu.au),
        Martin Stoffel (martin.adam.stoffel@gmail.com)
}
\keyword{models}
