% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{prevsim}
\alias{prevsim}
\title{Simulated patient dataset.}
\format{A data frame with 1000 rows and 6 columns:
\describe{
 \item{time}{time between date of diagnosis and death or censorship in days}
 \item{status}{event marker; 1 if patient is deceased and 0 if alive or censored}
 \item{age}{age in years at point of entry into the registry}
 \item{sex}{string with values 'M' and 'F'}
 \item{entrydate}{date of entry into the registry in YYYY-MM-DD format}
 \item{eventdate}{date of death or censorship in YYYY-MM-DD format}
}}
\usage{
prevsim
}
\description{
A dataset in the format of a disease registry, where the outcome being modelled is death
due to the simulated disease. The registry began in January 2003, with 1000 incident cases being
recorded over a period of nearly exactly ten years. The patients are followed up for a further
two years until 17.03.2015, at which point any subjects alive are marked as right censored.
}
\details{
Demographic and disease-specific data required for prevalence estimations are included,
such as sex, age, and dates of entry and event. \code{eventdate} marks the date of the
last known follow-up with the patient, corresponding to death (\code{status = 1}) or
censorship (\code{status = 0}).
}
\keyword{datasets}
