% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence.R
\name{yearly_incidence}
\alias{yearly_incidence}
\title{Disease incidence.}
\usage{
yearly_incidence(entry, start_date = NULL, num_years = NULL,
  end_date = NULL)
}
\arguments{
\item{entry}{Vector of diagnosis dates for each patient in the registry in
the format YYYY-MM-DD.}

\item{start_date}{The initial date in the \code{entry} vector to start estimating incidence from.}

\item{num_years}{The number of complete years to calculate incidence over. Defaults to the number of complete
years of registry data available in \code{entry}.}

\item{end_date}{The ending date in the \code{entry} vector to estimate incidence counting back from.
If both \code{end_date} and \code{start_date} are specified then \code{start_date} takes precedence.}
}
\value{
Vector of length \code{num_years} of integers, representing the number
  of absolute incidence values for each included year of the registry.
}
\description{
Calculates yearly incidence for the available registry data.
}
\examples{
data(prevsim)

yearly_incidence(prevsim$entrydate, start_date="2004-01-01", num_years=8)
yearly_incidence(prevsim$entrydate)
yearly_incidence(prevsim$entrydate, start_date="2005-05-01", num_years=5)
yearly_incidence(prevsim$entrydate, start_date="2005-05-01")
yearly_incidence(prevsim$entrydate, num_years=5, end_date="2015-05-01")

}
\seealso{
Other incidence functions: \code{\link{incidence_age_distribution}},
  \code{\link{incidence}},
  \code{\link{mean_incidence_rate}},
  \code{\link{plot.incidence}},
  \code{\link{raw_incidence}},
  \code{\link{test_incidence_fit}}
}
