% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_db_wrapper_fns.R
\name{dbAddKey}
\alias{dbAddKey}
\title{Add key.}
\usage{
dbAddKey(conn, name, colname, type = c("primary", "foreign"), reference,
  colref, display = TRUE, exec = TRUE)
}
\arguments{
\item{conn}{A connection object.}

\item{name}{A character string specifying a PostgreSQL table name.}

\item{colname}{A character string specifying the name of the
column to which the key will be assign.}

\item{type}{The type of the key, either \code{"primary"} or
\code{"foreign"}}

\item{reference}{A character string specifying a foreign table
name to which the foreign key will be associated.}

\item{colref}{A character string specifying the name of the
primary key in the foreign table to which the foreign key will
be associated.}

\item{display}{Logical. Whether to display the query (defaults to
\code{TRUE}).}

\item{exec}{Logical. Whether to execute the query (defaults to
\code{TRUE}).}
}
\value{
\code{TRUE} if the key was successfully added.
}
\description{
Add a primary or foreign key to a table column.
}
\examples{
## examples use a dummy connection from DBI package
conn<-DBI::ANSI()
dbAddKey(conn, name = c("schema", "table"), colname = "id", type = "foreign",
    reference = c("flu", "bla"), colref = "id", exec = FALSE)
}
\author{
Mathieu Basille \email{basille@ufl.edu}
}
\seealso{
The PostgreSQL documentation:
    \url{http://www.postgresql.org/docs/current/static/sql-altertable.html}
}

